/*
 * Decompiled with CFR 0.152.
 */
package jaxx.reflect;

import java.util.Arrays;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.reflect.MemberDescriptor;

public class MethodDescriptor
extends MemberDescriptor {
    private String returnType;
    private String[] parameterTypes;

    public MethodDescriptor(String name, int modifiers, String returnType, String[] parameterTypes, ClassLoader classLoader) {
        super(name, modifiers, classLoader);
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
    }

    public ClassDescriptor getReturnType() {
        try {
            if (this.returnType == null) {
                return null;
            }
            return ClassDescriptorLoader.getClassDescriptor(this.returnType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not find return type " + this.returnType, e);
        }
    }

    public ClassDescriptor[] getParameterTypes() {
        ClassDescriptor[] result = new ClassDescriptor[this.parameterTypes.length];
        try {
            for (int i = 0; i < result.length; ++i) {
                if (this.parameterTypes[i] == null) continue;
                result[i] = ClassDescriptorLoader.getClassDescriptor(this.parameterTypes[i], this.getClassLoader());
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not find the parameter types " + Arrays.toString(this.parameterTypes), e);
        }
    }
}

