/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.compiler;

import jaxx.reflect.ClassDescriptorLoader;

/**
 * A dummy CompiledObject which serves to initialize scripted field.  This is handled by
 * a CompiledObject rather than (say) simply inlining the initialization code in order to
 * ensure that the field is initialized in document order.
 */
public class ScriptInitializer extends CompiledObject {
    public ScriptInitializer(String initializer, JAXXCompiler  compiler) {
        super(compiler.getAutoId(ClassDescriptorLoader.getClassDescriptor(ScriptInitializer.class)),
                ClassDescriptorLoader.getClassDescriptor(ScriptInitializer.class), compiler, false);
        appendInitializationCode(initializer);
    }
}