/*
 * *##% 
 * I18n :: Maven Plugin
 * Copyright (C) 2007 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%* */

package org.nuiton.i18n.plugin.parser.impl;

import org.nuiton.i18n.plugin.parser.*;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.FileUpdaterHelper;
import org.nuiton.processor.filters.I18nFilter;

import java.io.*;

/**
 * Récupération des chaine a traduire depuis les fichiers java.
 *
 * @author julien
 * @goal parserJava
 * @phase generate-resources
 */
public class ParserJavaMojo extends AbstractI18nParserMojo {

    /**
     * Source entries (src+includes+excludes) .
     *
     * @parameter expression="${i18n.defaultIncludes}" default-value="**\/*.java"
     */
    protected String defaultIncludes;

    /**
     * default src for an entry.
     *
     * @parameter expression="${i18n.defaultBasedir}" default-value="${basedir}/src/main/java"
     */
    protected File defaultBasedir;

    /**
     * Repertoire sources des fichiers i18n.
     *
     * @parameter expression="${i18n.cp}" default-value="${basedir}/target/classes"
     * @required
     */
    protected File cp;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return defaultBasedir;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return FileUpdaterHelper.newJavaFileUpdater(entry.getBasedir(), cp);
    }

    @Override
    protected String getKeyModifierStart() {
        return "_\\(\\s*\"";
    }

    @Override
    protected String getKeyModifierEnd() {
        return "\"\\s*(\\)|,|\\+|$)";
    }

    @Override
    protected String getOutGetter() {
        return "java.getter";
    }

    protected I18nFilter filter;

    @Override
    public void init() throws Exception {
        super.init();
        filter = new I18nFilter();
    }

    @Override
    public void parseFile(File srcFile) throws IOException {
        String line = null;
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(
                new FileInputStream(srcFile)));
        try {
            while ((line = lnr.readLine())!=null) {
                parseLine(srcFile, line);
            }
//            while (lnr.ready()) {
//                line = lnr.readLine();
//                parseLine(srcFile, line);
//            }

        } catch (Exception e) {
            if (line != null) {
                getLog().error(
                        "could not parse line (" + lnr.getLineNumber() + ") '"
                        + line + "' of file " + srcFile);
            }
            throw new ParserException(e);
        } finally {
            lnr.close();
        }
    }

    @Override
    public void parseLine(File srcFile, String line) {
        String keysSet = filter.parse(line);

        if (!keysSet.equals(I18nFilter.EMPTY_STRING)) {
            // au moins une clef i18n a ete detectee dans le fichier
            touchFile = true;
            // Found a set of i18n Strings, split it.
            String[] keys = keysSet.split("=");
            for (String key : keys) {
                String keyModified = key;
                for (ParserEvent event : events) {
                    event.eventChangeKey(key, !oldLanguage.containsKey(key));
                    keyModified = event.eventGetRealKey();
                }
                Object value = oldParser.get(key);
                if (value == null) {
                    // nouvelle clef du parser, on utilise la clef comme valeur
                    value = key;
                }
                result.put(keyModified,value);
//                if (oldParser.containsKey(key)) {
//                    result.put(keyModified, oldParser.get(key));
//                } else {
//                    result.put(keyModified, key);
//                }
            }
        }
    }

}
