/*
 * #%L
 * Maven helper plugin
 * 
 * $Id: RestRequestBuilder.java 856 2012-07-18 00:14:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.5/src/main/java/org/nuiton/io/rest/RestRequestBuilder.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.io.rest;

import java.io.File;
import java.io.Serializable;
import java.util.Map;

/**
 * The contract of a request builder.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.3
 */
public interface RestRequestBuilder extends Serializable {

    /** @return the unique name of the request builder */
    String getName();

    /**
     * Checks that args used to create the request are fine.
     * <p/>
     * This method should be invoked just at the begin of the
     * method {@link #create(Object...)}.
     *
     * @param args the args of the request
     * @since 1.5
     */
    void checkRequestArgs(Object... args);

    /**
     * Create the request given the {@code args}.
     *
     * @param args args to create the request
     * @return the created request
     */
    RestRequest create(Object... args);

    /**
     * Computes the parameters associated to this requet.
     *
     * @param args the args of the request
     * @return parameters to use for this request
     * @since 1.5
     */
    String[] getParameters(Object... args);

    /**
     * Computes the path associated to this request.
     *
     * @param args the args of the request
     * @return path to use for this request
     * @since 1.5
     */
    String[] getPath(Object... args);

    /**
     * Computes the map of attachments associated to this request
     *
     * @param args the args of the request
     * @return map of attachments to use for this request
     * @since 1.5
     */
    Map<String, File> getAttachments(Object... args);
}
