/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.tags;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.nuiton.guix.tags.TagHandler;

public abstract class DefaultTagHandler
implements TagHandler {
    protected Map<String, String> attrMap = new HashMap<String, String>();
    private Map<String, ProxyEventInfo> eventInfos;
    protected BeanInfo beanInfo;
    private Map<String, PropertyDescriptor> properties;
    private Map<String, EventSetDescriptor> events;

    protected void init() throws IntrospectionException {
        if (this.beanInfo == null) {
            this.beanInfo = Introspector.getBeanInfo(this.getClassToGenerate());
            PropertyDescriptor[] propertiesArray = this.beanInfo.getPropertyDescriptors();
            this.properties = new HashMap<String, PropertyDescriptor>();
            for (int i = propertiesArray.length - 1; i >= 0; --i) {
                this.properties.put(propertiesArray[i].getName(), propertiesArray[i]);
            }
            EventSetDescriptor[] eventsArray = this.beanInfo.getEventSetDescriptors();
            this.events = new HashMap<String, EventSetDescriptor>();
            for (int i = eventsArray.length - 1; i >= 0; --i) {
                Method[] methods;
                for (Method method : methods = eventsArray[i].getListenerMethods()) {
                    this.events.put(method.getName(), eventsArray[i]);
                }
            }
            this.configureProxyEventInfo();
        }
    }

    protected void configureProxyEventInfo() {
    }

    public void addProxyEventInfo(String memberName, Class listenerClass) {
        this.addProxyEventInfo(memberName, listenerClass, null);
    }

    public void addProxyEventInfo(String memberName, Class listenerClass, String modelName) {
        String listenerName = listenerClass.getName();
        listenerName = listenerName.substring(listenerName.lastIndexOf(".") + 1);
        this.addProxyEventInfo(memberName, listenerClass, modelName, "add" + listenerName, "remove" + listenerName);
    }

    public void addProxyEventInfo(String memberName, Class listenerClass, String modelName, String addMethod, String removeMethod) {
        ProxyEventInfo info = new ProxyEventInfo();
        info.memberName = memberName;
        info.listenerClass = listenerClass;
        info.modelName = modelName;
        info.addMethod = addMethod;
        info.removeMethod = removeMethod;
        if (this.eventInfos == null) {
            this.eventInfos = new HashMap<String, ProxyEventInfo>();
        }
        this.eventInfos.put(memberName, info);
    }

    @Override
    public boolean hasEventInfosAboutMethod(String methodName) {
        return this.eventInfos != null && this.eventInfos.get(methodName) != null;
    }

    @Override
    public Class getEventInfosListenerClass(String methodName) {
        return this.eventInfos.get(methodName) != null ? this.eventInfos.get((Object)methodName).listenerClass : null;
    }

    @Override
    public String getEventInfosAddListenerMethodName(String methodName) {
        return this.eventInfos.get(methodName) != null ? this.eventInfos.get((Object)methodName).addMethod : null;
    }

    @Override
    public String getEventInfosRemoveListenerMethodName(String methodName) {
        return this.eventInfos.get(methodName) != null ? this.eventInfos.get((Object)methodName).removeMethod : null;
    }

    @Override
    public String getEventInfosModelName(String methodName) {
        return this.eventInfos.get(methodName) != null ? this.eventInfos.get((Object)methodName).modelName : null;
    }

    @Override
    public String getAttrToGenerate(String attr) {
        return this.attrMap.get(attr);
    }

    @Override
    public String getDefaultConstructor() {
        return null;
    }

    private class ProxyEventInfo {
        String memberName;
        Class listenerClass;
        String modelName;
        String addMethod;
        String removeMethod;

        private ProxyEventInfo() {
        }
    }
}

