/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.GuixLauncher;
import org.nuiton.guix.model.AttributeDescriptor;
import org.nuiton.guix.model.ClassDescriptor;
import org.nuiton.guix.model.GuixModelObject;
import org.nuiton.guix.model.StyleSheet;
import org.nuiton.guix.tags.ScriptHandler;
import org.nuiton.guix.tags.StyleHandler;
import org.nuiton.guix.tags.TagManager;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class GuixCompiler {
    private static final String STYLE_TAG = "style";
    private static final String SCRIPT_TAG = "script";
    private static final String CONSTRUCTOR_PARAMS_ATTRIBUTE = "constructor";
    private static final String ID_ATTRIBUTE = "id";
    private static final String STYLE_CLASS_ATTRIBUTE = "styleClass";
    private static final String SOURCE_ATTRIBUTE = "source";
    private static final String JAVA_BEAN_ATTRIBUTE = "javaBean";
    private Log log = LogFactory.getLog(GuixCompiler.class);
    private int index = 1;
    private StyleHandler styleHandler = new StyleHandler();
    private ScriptHandler scriptHandler = new ScriptHandler();
    private File baseDir;
    protected boolean failed;
    private long lastModification;
    private GuixLauncher launcher;
    private GuixModelObject rootMO;
    private File src;
    private String srcPackage;
    private String generationLanguage;

    public GuixCompiler(File src, GuixLauncher launcher, String srcPackage, String generationLanguage) {
        this.src = src;
        this.launcher = launcher;
        this.srcPackage = srcPackage != null ? srcPackage : "";
        if (src != null) {
            this.baseDir = src.getParentFile();
            this.lastModification = src.lastModified();
        }
        this.generationLanguage = generationLanguage;
    }

    public GuixModelObject compile() {
        block20: {
            if (this.src != null && this.launcher != null && this.generationLanguage != null) {
                try {
                    XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
                    factory.setNamespaceAware(true);
                    XmlPullParser xpp = factory.newPullParser();
                    xpp.setInput((Reader)new FileReader(this.src));
                    if (xpp.getEventType() != 0) break block20;
                    StringBuffer doc = new StringBuffer();
                    do {
                        xpp.nextToken();
                        if (xpp.getEventType() != 9) continue;
                        doc.append(xpp.getText());
                    } while (xpp.getEventType() != 2);
                    if (xpp.getPrefix() != null && !xpp.getPrefix().equalsIgnoreCase(this.generationLanguage)) break block20;
                    String tagNameSpace = xpp.getNamespace();
                    String tagName = xpp.getName().lastIndexOf(46) >= 0 ? xpp.getName().substring(xpp.getName().lastIndexOf(46) + 1) : xpp.getName();
                    String tagPackageName = this.resolvePackageName(tagNameSpace, xpp.getName());
                    String id = xpp.getAttributeValue("", ID_ATTRIBUTE) != null ? xpp.getAttributeValue("", ID_ATTRIBUTE) : "_" + tagName + this.index++;
                    this.rootMO = new GuixModelObject(id, xpp.getAttributeValue("", CONSTRUCTOR_PARAMS_ATTRIBUTE), doc.toString(), xpp.getAttributeValue("", STYLE_CLASS_ATTRIBUTE));
                    String className = this.src.getName().substring(0, this.src.getName().lastIndexOf(46));
                    ClassDescriptor cd = new ClassDescriptor(className, this.srcPackage);
                    cd.setSuperClass(new ClassDescriptor(tagName, tagPackageName));
                    this.rootMO.setClassDescriptor(this.launcher.registerClassDescriptor(cd));
                    this.failed = cd == null;
                    try {
                        ClassLoader.getSystemClassLoader().loadClass(this.rootMO.getClassDescriptor().getSuperClass().toString());
                    }
                    catch (ClassNotFoundException eee) {
                        try {
                            ClassDescriptor superCD = this.rootMO.getClassDescriptor().getSuperClass();
                            if (!this.launcher.getGuixFileClassNames().contains(this.rootMO.getClassDescriptor().getSuperClass())) {
                                File f = new File(this.launcher.getSrcDirectory(), superCD.toString().replace('.', File.separatorChar) + ".guix");
                                if (!f.exists()) {
                                    f = new File(this.launcher.getSrcDirectory(), superCD.toString().replace('.', File.separatorChar) + ".jaxx");
                                }
                                if (f.exists() && !this.launcher.isFileAlreadyCompiled(f)) {
                                    GuixCompiler gc = new GuixCompiler(f, this.launcher, superCD.getPackageName(), this.generationLanguage);
                                    GuixModelObject rootMO = gc.compile();
                                    this.launcher.addCompiledFile(f);
                                    this.launcher.addClassName(superCD.toString());
                                    this.launcher.addRootModelObject(rootMO, gc.getLastModification());
                                    if (gc.isFailed()) {
                                        this.failed = true;
                                    }
                                }
                                if (f.exists()) {
                                    this.launcher.addDependency(this.rootMO, superCD);
                                }
                            } else {
                                this.launcher.addDependency(this.rootMO, superCD);
                            }
                        }
                        catch (NullPointerException eeee) {
                            // empty catch block
                        }
                    }
                    this.rootMO.setAttributeDescriptors(this.getAttributes(xpp));
                    this.rootMO.setChildren(new ArrayList<GuixModelObject>());
                    File styleFile = new File(this.src.getParentFile(), className + ".css");
                    if (styleFile.exists()) {
                        this.rootMO.getCssFiles().add(styleFile);
                        StyleSheet ss = this.styleHandler.autoDetectStyleFile(styleFile);
                        this.rootMO.getStyleSheets().add(ss);
                        this.lastModification = Math.max(this.lastModification, styleFile.lastModified());
                    }
                    StringBuffer script = new StringBuffer();
                    File scriptFile = new File(this.src.getParentFile(), className + ".script");
                    if (scriptFile.exists()) {
                        script.append(this.scriptHandler.loadScriptFile(scriptFile));
                        this.lastModification = Math.max(this.lastModification, scriptFile.lastModified());
                    }
                    do {
                        xpp.nextToken();
                    } while (xpp.getEventType() != 2 && xpp.getEventType() != 1);
                    if (xpp.getEventType() == 2) {
                        script.append(this.compile(xpp, this.rootMO, doc.toString()));
                    }
                    this.rootMO.getClassDescriptor().setScript(script.toString());
                    return this.rootMO;
                }
                catch (XmlPullParserException ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)ex);
                    }
                }
                catch (IOException ex) {
                    if (!this.log.isErrorEnabled()) break block20;
                    this.log.error((Object)ex);
                }
            }
        }
        this.failed = true;
        return null;
    }

    protected StringBuffer compile(XmlPullParser xpp, GuixModelObject previousMO, String javaDoc) {
        StringBuffer result;
        block32: {
            result = new StringBuffer();
            StringBuffer doc = new StringBuffer();
            try {
                GuixModelObject prev;
                if (xpp.getPrefix() == null || xpp.getPrefix().equalsIgnoreCase(this.generationLanguage)) {
                    String source;
                    if (xpp.getName() != null && xpp.getName().equals(STYLE_TAG)) {
                        StyleSheet ss;
                        File styleFile = null;
                        source = xpp.getAttributeValue("", SOURCE_ATTRIBUTE);
                        if (source != null) {
                            styleFile = new File(this.baseDir, source.replace('/', File.separatorChar));
                        }
                        if ((ss = this.styleHandler.compileStyle(xpp, styleFile)) != null) {
                            this.rootMO.getStyleSheets().add(ss);
                        }
                        if (styleFile != null && styleFile.exists()) {
                            this.rootMO.getCssFiles().add(styleFile);
                            this.lastModification = Math.max(this.lastModification, styleFile.lastModified());
                        }
                        prev = previousMO;
                    } else if (xpp.getName() != null && xpp.getName().equals(SCRIPT_TAG)) {
                        File scriptFile = null;
                        source = xpp.getAttributeValue("", SOURCE_ATTRIBUTE);
                        if (source != null) {
                            scriptFile = new File(this.baseDir, source.replace('/', File.separatorChar));
                        }
                        result.append(this.scriptHandler.compileScript(xpp, scriptFile));
                        if (scriptFile != null && scriptFile.exists()) {
                            this.lastModification = Math.max(this.lastModification, scriptFile.lastModified());
                        }
                        prev = previousMO;
                    } else {
                        String tagNameSpace = xpp.getNamespace();
                        String tagPackageName = this.resolvePackageName(tagNameSpace, xpp.getName());
                        String tagName = xpp.getName().lastIndexOf(46) >= 0 ? xpp.getName().substring(xpp.getName().lastIndexOf(46) + 1) : xpp.getName();
                        String id = xpp.getAttributeValue("", ID_ATTRIBUTE) != null ? xpp.getAttributeValue("", ID_ATTRIBUTE) : "_" + tagName + this.index++;
                        GuixModelObject mo = new GuixModelObject(id, xpp.getAttributeValue("", CONSTRUCTOR_PARAMS_ATTRIBUTE), javaDoc, xpp.getAttributeValue("", STYLE_CLASS_ATTRIBUTE));
                        mo.setJavaBean(xpp.getAttributeValue("", JAVA_BEAN_ATTRIBUTE) == null || Boolean.valueOf(xpp.getAttributeValue("", JAVA_BEAN_ATTRIBUTE)) != false);
                        ClassDescriptor cd = this.launcher.registerClassDescriptor(new ClassDescriptor(tagName, tagPackageName));
                        mo.setClassDescriptor(cd);
                        this.failed = cd == null;
                        try {
                            ClassLoader.getSystemClassLoader().loadClass(tagPackageName + "." + tagName);
                        }
                        catch (ClassNotFoundException eee) {
                            try {
                                if (!this.launcher.getGuixFileClassNames().contains(tagPackageName + "." + tagName)) {
                                    File f = new File(this.launcher.getSrcDirectory(), tagPackageName.replace('.', File.separatorChar) + File.separatorChar + tagName + ".guix");
                                    if (!f.exists()) {
                                        f = new File(this.launcher.getSrcDirectory(), tagPackageName.replace('.', File.separatorChar) + File.separatorChar + tagName + ".jaxx");
                                    }
                                    if (f.exists() && !this.launcher.isFileAlreadyCompiled(f)) {
                                        GuixCompiler gc = new GuixCompiler(f, this.launcher, tagPackageName, this.generationLanguage);
                                        GuixModelObject rootMO = gc.compile();
                                        this.launcher.addCompiledFile(f);
                                        this.launcher.addClassName(tagPackageName + "." + tagName);
                                        this.launcher.addRootModelObject(rootMO, gc.getLastModification());
                                        if (gc.isFailed()) {
                                            this.failed = true;
                                        }
                                    }
                                    if (f.exists()) {
                                        this.launcher.addDependency(this.rootMO, mo.getClassDescriptor());
                                    }
                                } else {
                                    this.launcher.addDependency(this.rootMO, mo.getClassDescriptor());
                                }
                            }
                            catch (NullPointerException eeee) {
                                // empty catch block
                            }
                        }
                        mo.setParent(previousMO);
                        mo.setAttributeDescriptors(this.getAttributes(xpp));
                        mo.setChildren(new ArrayList<GuixModelObject>());
                        previousMO.getChildren().add(mo);
                        if (!this.failed) {
                            prev = mo;
                        } else {
                            return null;
                        }
                    }
                    do {
                        xpp.nextToken();
                        if (xpp.getEventType() == 3) {
                            prev = prev.getParent();
                            continue;
                        }
                        if (xpp.getEventType() != 9) continue;
                        doc.append(xpp.getText());
                    } while (xpp.getEventType() != 2 && xpp.getEventType() != 1);
                } else {
                    prev = previousMO;
                    String prefix = xpp.getPrefix();
                    String tagName = xpp.getName();
                    do {
                        xpp.nextToken();
                    } while ((xpp.getEventType() != 3 || xpp.getPrefix() == null ^ prefix == null || xpp.getPrefix() != null && prefix != null && !xpp.getPrefix().equals(prefix) || xpp.getName() == null ^ tagName == null || xpp.getName() != null && tagName != null && !xpp.getName().equals(tagName)) && xpp.getEventType() != 1);
                    do {
                        xpp.nextToken();
                        if (xpp.getEventType() != 9) continue;
                        doc.append(xpp.getText());
                    } while (xpp.getEventType() != 2 && xpp.getEventType() != 1);
                }
                if (xpp.getEventType() == 2) {
                    result.append(this.compile(xpp, prev, doc.toString()));
                }
            }
            catch (XmlPullParserException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)ex);
                }
            }
            catch (IOException ex) {
                if (!this.log.isErrorEnabled()) break block32;
                this.log.error((Object)ex);
            }
        }
        return result;
    }

    private String resolvePackageName(String tagNameSpace, String tagName) {
        String packageName = null;
        if (tagNameSpace != null && tagNameSpace.endsWith("*")) {
            packageName = tagNameSpace.substring(0, tagNameSpace.length() - 2);
        }
        if (tagName.lastIndexOf(46) >= 0) {
            packageName = packageName == null ? tagName.substring(0, tagName.lastIndexOf(46)) : packageName + tagName.substring(0, tagName.lastIndexOf(46));
        }
        if (packageName == null) {
            String fullClassName = TagManager.resolveClassName(tagName);
            packageName = fullClassName == null || fullClassName.lastIndexOf(46) == -1 ? null : fullClassName.substring(0, fullClassName.lastIndexOf(46));
        }
        return packageName;
    }

    private List<AttributeDescriptor> getAttributes(XmlPullParser xpp) {
        ArrayList<AttributeDescriptor> result = new ArrayList<AttributeDescriptor>();
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            if (xpp.getAttributeName(i).equals(ID_ATTRIBUTE) || xpp.getAttributeName(i).equals(CONSTRUCTOR_PARAMS_ATTRIBUTE) || xpp.getAttributeName(i).equals(STYLE_CLASS_ATTRIBUTE) || xpp.getAttributeName(i).equals(JAVA_BEAN_ATTRIBUTE)) continue;
            result.add(new AttributeDescriptor(xpp.getAttributeName(i), xpp.getAttributeValue(i)));
        }
        return result;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public long getLastModification() {
        return this.lastModification;
    }
}

