/**
 * *##% guix-compiler
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.nuiton.guix.model;

/**
 * Descriptor of tag attributes
 *
 * @author morin
 */
public class AttributeDescriptor {

    /** Name of the attribute */
    private String name;

    /** Value of the attribute */
    private String value;

    /**
     * Constructor
     *
     * @param name  name of the attribute
     * @param value value of the attribute
     */
    public AttributeDescriptor(String name, String value) {
        this.name  = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return name + " : " + value;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
