/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.nuiton.eugene.ModelFileWriter;
import org.nuiton.eugene.ModelFileWriterConfiguration;
import org.nuiton.eugene.ModelFileWriterUtil;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.plugin.AbstractEugeneMojo;
import org.nuiton.eugene.plugin.writer.BaseModelFileWriter;

public class GeneratateModelFilesMojo
extends AbstractEugeneMojo
implements ModelFileWriterConfiguration {
    protected String[] includes;
    protected File outputDirectory;
    protected Map<String, Object> properties;
    protected boolean dryRun;
    protected String fullPackagePath;
    protected String extractedPackages;
    protected String resolver;
    protected File extraClassPathDirectory;
    protected Map<String, ModelFileWriter> writers;
    protected Set<ModelFileWriter> availableWriters;
    protected List<ModelFileWriter> plan;

    @Override
    protected boolean init() throws Exception {
        boolean b = super.init();
        if (b) {
            if (this.includes.length == 0) {
                throw new MojoExecutionException("Must specify something to include using the includes property");
            }
            this.availableWriters = ModelFileWriterUtil.filterWriterForModelType(this.writers, this.getModelClass());
            if (this.availableWriters.isEmpty()) {
                throw new MojoExecutionException("Could not find any writer in class-path.");
            }
            for (ModelFileWriter writer : this.availableWriters) {
                if (!(writer instanceof BaseModelFileWriter)) continue;
                ((BaseModelFileWriter)writer).setLog(this.getLog());
            }
            this.plan = new ArrayList<ModelFileWriter>();
            for (String include : this.includes) {
                this.getLog().info((CharSequence)("Register include : " + include));
                ModelFileWriterUtil.registerInclude((ModelFileWriterConfiguration)this, (String)include, this.plan);
            }
            if (this.properties == null) {
                this.properties = new TreeMap<String, Object>();
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        if (this.dryRun) {
            this.getLog().warn((CharSequence)"dryRun property is set, no file will be generated.");
        }
        try {
            ClassLoader loader = this.fixClassLoader();
            this.properties.put("classLoader", loader);
            this.properties.put("fullPackagePath", this.fullPackagePath);
            this.properties.put("resolver", this.resolver);
            for (ModelFileWriter writer : this.plan) {
                int size = writer.getEntries().size();
                if (size == 1) {
                    this.getLog().info((CharSequence)("Process phase [" + writer.getInputProtocol() + "] for one entry."));
                } else {
                    this.getLog().info((CharSequence)("Process phase [" + writer.getInputProtocol() + "] for " + size + " entries."));
                }
                if (this.dryRun || this.isVerbose()) {
                    for (ModelFileWriterUtil.ModelFileWriterEntry entry : writer.getEntries()) {
                        this.getLog().info((CharSequence)(" entry : " + entry.getInputDirectory() + " - " + entry.getIncludePattern()));
                    }
                    if (this.dryRun) continue;
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Generating files and copying resources...");
                }
                writer.generate((ModelFileWriterConfiguration)this);
            }
        }
        finally {
            this.properties.clear();
            for (ModelFileWriter writer : this.plan) {
                writer.clear();
            }
            this.plan.clear();
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Set<ModelFileWriter> getAvailableWriters() {
        return this.availableWriters;
    }

    public Class<? extends Model> getModelClass() {
        return this.modelClass;
    }

    public File getBasedir() {
        return this.getProject().getBasedir();
    }

    protected ClassLoader fixClassLoader() throws MojoExecutionException {
        HashSet urlsAsString = new HashSet();
        ArrayList urls = new ArrayList();
        try {
            if (this.extraClassPathDirectory != null) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Add extra directory in generator's classLoader : " + this.extraClassPathDirectory));
                }
                this.addDirectoryToUrlsList(this.extraClassPathDirectory, urls, urlsAsString);
            }
            if (this.project.getProjectReferences() != null) {
                Iterator i$ = this.project.getProjectReferences().entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    MavenProject relatedProject = (MavenProject)entry.getValue();
                    if (this.verbose) {
                        this.getLog().info((CharSequence)("Add project reference in generator's classLoader : '" + relatedProject.getArtifact() + "'"));
                    }
                    this.addDirectoryToUrlsList(relatedProject.getArtifact().getFile(), urls, urlsAsString);
                }
            }
            if (!this.project.getArtifacts().isEmpty()) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)"Use resolved artifacts to build class-path");
                }
                for (Map.Entry o : this.project.getArtifacts()) {
                    Artifact a = (Artifact)o;
                    if (a.getScope().equals("provided")) continue;
                    this.addDirectoryToUrlsList(a.getFile(), urls, urlsAsString);
                }
            }
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)("original classloader " + loader));
            }
            if (loader instanceof URLClassLoader) {
                for (URL u : ((URLClassLoader)loader).getURLs()) {
                    this.addUrlToUrlsList(u, urls, urlsAsString);
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("original cp entry: " + u));
                }
                if (loader.getParent() != null) {
                    loader = loader.getParent();
                }
            }
            if (!urls.isEmpty()) {
                loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), loader);
            }
            if (this.getLog().isDebugEnabled()) {
                for (URL u : urls) {
                    this.getLog().debug((CharSequence)("cp entry: " + u));
                }
            }
            ClassLoader classLoader = loader;
            return classLoader;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            urls.clear();
            urlsAsString.clear();
        }
    }
}

