package org.nuiton.eugene.plugin.writer;

import org.nuiton.eugene.models.Model;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;

import java.io.File;
import java.io.IOException;

/**
 * @author tchemit
 * @plexus.component role="org.nuiton.eugene.ModelFileWriter" role-hint="zargo2xmi" description="zargo to xmi model"
 * @since 2.0.0
 */
public class ZargoModelFileWriter extends BaseModelFileWriter {

    public static final String[] XMI_FILE_FILTER = new String[]{"*.xmi", "**/*.xmi"};

    @Override
    public String getInputProtocol() {
        return "zargo";
    }

    @Override
    public <M extends Model> String getOutputProtocol(Class<M> modelType) {
        // next writer to use is a xmi to model one
        return "xmi";
    }

    @Override
    public <M extends Model> boolean acceptModel(Class<M> modelType) {
        // accept all models
        return true;
    }

    @Override
    public boolean acceptInclude(String include) {
        return include.startsWith("zargo:") || include.endsWith(".zargo") || include.endsWith(".zuml");
    }

    @Override
    public String getDefaultIncludes() {
        return "**/*.zargo";
    }

    @Override
    public String getDefaultInputDirectory() {
        return "src/main/xmi";
    }

    @Override
    public String getDefaultOutputDirectory() {
        return "xmi";
    }

    @Override
    public void generate(File outputDir, File inputDirectory, String includePattern, boolean overwrite) throws IOException {

        PluginIOContext ioContext = new PluginIOContext();
        ioContext.setInput(inputDirectory);
        ioContext.setOutput(outputDir);

        getLog().info("Expanding xmi from " + inputDirectory + " : " + includePattern);
        PluginHelper.expandFiles(ioContext, new String[]{includePattern}, null, XMI_FILE_FILTER, overwrite);

        getLog().info("Copying resources from " + inputDirectory + " : " + includePattern);
        PluginHelper.copyFiles(ioContext, null, new String[]{includePattern}, overwrite);
    }
}
