/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.renderer;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.ObjectModelParameter;

public class TagValuesReportRenderer
extends AbstractMavenReportRenderer {
    protected final I18N i18n;
    protected final Locale locale;
    protected final String bundleName;
    protected final Collection<TagValueMetadatasProvider> data;
    protected final String javaDocDestDir;
    protected final String jxrDestDir;

    public String getTitle() {
        return this.getText("report.title");
    }

    public void renderBody() {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.overview.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.link(this.getEugeneDocLink());
        this.sink.text(this.getText("report.overview.more.information"));
        this.sink.link_();
        this.sink.paragraph_();
        for (TagValueMetadatasProvider provider : this.data) {
            String implementation = provider.getClass().getName();
            this.sink.section2();
            this.sink.sectionTitle2();
            this.sink.text(provider.getDescription());
            this.sink.sectionTitle2_();
            this.sink.lineBreak();
            this.sink.paragraph();
            this.sink.bold();
            this.sink.text(implementation);
            this.sink.bold_();
            this.sink.text(" ");
            this.sink.link("./" + this.javaDocDestDir + "/" + implementation.replace('.', '/') + ".html");
            this.sink.text("javadoc");
            this.sink.link_();
            this.sink.link("./" + this.jxrDestDir + "/" + implementation.replace('.', '/') + ".html");
            this.sink.text(" ");
            this.sink.text("xref");
            this.sink.link_();
            this.sink.text(".");
            this.sink.paragraph_();
            this.sink.table();
            this.sink.tableRow();
            this.sinkHeaderCellText(this.getText("report.tagValue.name"));
            this.sinkHeaderCellText(this.getText("report.tagValue.description"));
            this.sink.tableRow_();
            for (TagValueMetadata entry : provider.getTagValues()) {
                String tagValueName = entry.getName();
                this.sink.tableRow();
                this.sinkCellLink(tagValueName, "./" + this.bundleName + ".html#detail_" + tagValueName);
                this.sinkCellText(entry.getDescription());
                this.sink.tableRow_();
            }
            this.sink.table_();
            this.sink.section2_();
        }
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.overview.detail"));
        this.sink.sectionTitle1_();
        for (TagValueMetadatasProvider provider : this.data) {
            if (!CollectionUtils.isNotEmpty((Collection)provider.getTagValues())) continue;
            this.sink.section2();
            this.sink.sectionTitle2();
            this.sink.text(this.getText("report.detail.title") + provider.getDescription());
            this.sink.sectionTitle2_();
            for (TagValueMetadata detail : provider.getTagValues()) {
                this.sink.section2();
                this.sink.sectionTitle2();
                this.sink.anchor("detail_" + detail.getName());
                this.sink.text(this.getText("report.detail.tagValue.title") + "   " + detail.getName());
                this.sink.anchor_();
                this.sink.sectionTitle2_();
                this.sink.lineBreak();
                this.sink.table();
                this.sink.tableRow();
                this.sinkHeaderCellText(this.getText("report.detail.tagValue.name"));
                this.sinkCellText(detail.getName());
                this.sink.tableRow_();
                this.sink.tableRow();
                this.sinkHeaderCellText(this.getText("report.detail.tagValue.description"));
                this.sinkCellText(detail.getDescription());
                this.sink.tableRow_();
                this.sink.tableRow();
                this.sinkHeaderCellText(this.getText("report.detail.tagValue.defaultValue"));
                this.sinkCellText(detail.getDefaultValue());
                this.sink.tableRow_();
                this.sink.tableRow();
                this.sinkHeaderCellText(this.getText("report.detail.tagValue.matcherClass"));
                this.sinkCellText(detail.getMatcherClass().getName());
                this.sink.tableRow_();
                this.sink.tableRow();
                this.sinkHeaderCellText(this.getText("report.detail.tagValue.target"));
                this.sink.tableCell();
                this.renderTargets(detail.getTargets());
                this.sink.tableCell_();
                this.sink.tableRow_();
                this.sink.table_();
                this.sink.section3();
                this.sink.sectionTitle3();
                this.sink.text(this.getText("report.detail.tagValue.usage.title"));
                this.sink.sectionTitle3_();
                this.sink.text("//TODO Example of usage of this tag value");
                this.sink.section3_();
                this.sink.section2_();
            }
            this.sink.section2_();
        }
        this.sink.section1_();
    }

    public TagValuesReportRenderer(Sink sink, I18N i18n, Locale locale, String bundleName, String javaDocDestDir, String jxrDestDir, Collection<TagValueMetadatasProvider> data) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
        this.bundleName = bundleName;
        this.javaDocDestDir = javaDocDestDir;
        this.jxrDestDir = jxrDestDir;
        this.data = data;
        this.sink = sink;
    }

    protected String getEugeneDocLink() {
        String url = this.locale.getCountry().equals(Locale.FRENCH.getCountry()) ? "http://eugene.nuiton.org/v/latest/fr/eugene/tagValues.html" : "http://eugene.nuiton.org/v/latest/eugene/tagValues.html";
        return url;
    }

    protected String getText(String key) {
        return this.i18n.getString(this.bundleName, this.locale, key);
    }

    protected void sinkHeaderCellText(String text) {
        this.sink.tableHeaderCell();
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void sinkHeaderCellText(SinkEventAttributes width, String text) {
        this.sink.tableHeaderCell(width);
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void sinkCellText(SinkEventAttributes width, String text) {
        this.sink.tableCell(width);
        this.sink.text(text);
        this.sink.tableCell_();
    }

    protected void sinkCellText(String text) {
        this.sink.tableCell();
        this.sink.text(text);
        this.sink.tableCell_();
    }

    protected void sinkCellLink(String text, String url) {
        this.sink.tableCell();
        this.sink.link(url);
        this.sink.text(text);
        this.sink.link_();
        this.sink.tableCell_();
    }

    protected void renderTargets(Set<Class<?>> targets) {
        boolean moreThanOne;
        boolean bl = moreThanOne = targets.size() > 1;
        if (moreThanOne) {
            this.sink.list_();
        }
        for (Class<?> target : targets) {
            if (moreThanOne) {
                this.sink.listItem();
            }
            this.renderDetailTarget(target);
            if (!moreThanOne) continue;
            this.sink.listItem_();
        }
        if (moreThanOne) {
            this.sink.list_();
        }
    }

    protected void renderDetailTarget(Class<?> target) {
        if (ObjectModel.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.model"));
        } else if (ObjectModelPackage.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.package"));
        } else if (ObjectModelClassifier.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.classifier"));
        } else if (ObjectModelClass.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.class"));
        } else if (ObjectModelInterface.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.interface"));
        } else if (ObjectModelEnumeration.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.enumeration"));
        } else if (ObjectModelAttribute.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.attribute"));
        } else if (ObjectModelParameter.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.parameter"));
        } else if (ObjectModelOperation.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.operation"));
        } else if (ObjectModelElement.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.element"));
        }
    }
}

