/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelReader;
import org.nuiton.eugene.models.state.StateModelReader;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;
import org.nuiton.util.ZipUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GeneratorTask
extends MatchingTask {
    protected String templates;
    protected File srcDir;
    protected File srcFile;
    protected File destDir;
    protected String transformations = "object";
    protected String resolver;
    protected Properties properties = new Properties();
    protected boolean overwrite;
    protected String encoding = "UTF-8";
    protected String buildDirectory = "build";

    public void setTemplates(String templates) {
        this.templates = templates;
    }

    public void setTransformations(String transformations) {
        this.transformations = transformations;
    }

    public void setProperties(String properties) {
        String[] props;
        for (String prop : props = properties.split(",")) {
            String[] pv = prop.split("=");
            this.properties.put(pv[0], pv[1]);
        }
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setSrcfile(File srcFile) {
        this.srcFile = srcFile;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setBuilddirectory(String buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public void execute() throws BuildException {
        if (this.templates == null) {
            throw new BuildException("templates attribute must be set!", this.getLocation());
        }
        if (this.destDir == null) {
            throw new BuildException("destDir attribute must be set!", this.getLocation());
        }
        if (!this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.getLocation());
        }
        if (this.srcFile == null && this.srcDir == null) {
            throw new BuildException("srcFile or srcDir attribute must be set!", this.getLocation());
        }
        if (this.srcFile != null && !this.srcFile.isFile()) {
            throw new BuildException("src file \"" + this.srcFile + "\" does not exist or is not a file", this.getLocation());
        }
        String[] templateGenerators = this.templates.split(",");
        Template[] generators = new Template[templateGenerators.length];
        for (int i = 0; i < templateGenerators.length; ++i) {
            String templateName = templateGenerators[i].trim();
            try {
                generators[i] = (Template)Class.forName(templateName).newInstance();
                this.properties.setProperty("overwrite", String.valueOf(this.overwrite));
                this.properties.setProperty("encoding", this.encoding);
                generators[i].setProperties(this.properties);
                continue;
            }
            catch (ClassCastException e) {
                this.log("Generator don't inherit Template Class", e, 0);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.log("Unable to find generator " + templateName, e, 0);
                continue;
            }
            catch (InstantiationException e) {
                this.log("Unable to instanciate template " + templateName, e, 0);
                continue;
            }
            catch (IllegalAccessException e) {
                this.log("Unable to parse input file " + templateName, e, 0);
            }
        }
        if (this.srcFile != null) {
            this.doExecute(this.srcFile, this.destDir, generators);
        } else {
            DirectoryScanner scanner = this.getDirectoryScanner(this.srcDir);
            String[] includedFilenames = scanner.getIncludedFiles();
            ArrayList<File> includedFiles = new ArrayList<File>(includedFilenames.length);
            for (String includedFilename : includedFilenames) {
                includedFiles.add(new File(this.srcDir, includedFilename));
            }
            this.doExecute(includedFiles, this.destDir, generators);
        }
    }

    protected void doExecute(File srcFile, File destDir, Template<Model>[] generators) throws BuildException {
        this.doExecute(Collections.singletonList(srcFile), destDir, generators);
    }

    protected void doExecute(List<File> srcFiles, File destDir, Template<Model>[] generators) throws BuildException {
        List<File> modelFiles = this.doConvertFiles(srcFiles, destDir);
        for (Template<Model> generator : generators) {
            String[] transformationsArray;
            if (generator == null) continue;
            Object[] modelFilesArray = modelFiles.toArray(new File[modelFiles.size()]);
            this.log("Applying " + generator.getClass().getSimpleName() + " on " + Arrays.toString(modelFilesArray), 2);
            for (String transformation : transformationsArray = this.transformations.split(",")) {
                ObjectModel model;
                if ("object".equals(transformation)) {
                    ObjectModelReader objectModelReader = new ObjectModelReader();
                    model = (ObjectModel)objectModelReader.read((File[])modelFilesArray);
                    try {
                        generator.applyTemplate((Model)model, destDir);
                        continue;
                    }
                    catch (IOException e) {
                        throw new BuildException("Can't apply template on object model", (Throwable)e);
                    }
                }
                if (!"state".equals(transformation)) continue;
                StateModelReader stateModelReader = new StateModelReader();
                model = stateModelReader.read((File[])modelFilesArray);
                try {
                    generator.applyTemplate((Model)model, destDir);
                }
                catch (IOException e) {
                    throw new BuildException("Can't apply template on state model", (Throwable)e);
                }
            }
        }
    }

    protected List<File> doConvertFiles(List<File> srcFiles, File destDir) {
        ArrayList<File> result = new ArrayList<File>();
        String[] transformationsArray = this.transformations.split(",");
        for (File file : srcFiles) {
            File currentFile = file;
            if (this.isArchiveFile(currentFile)) {
                File unzipDirectory = new File(this.buildDirectory, "xmi");
                if (unzipDirectory.exists()) {
                    unzipDirectory.mkdirs();
                }
                this.log("Unzip " + currentFile.getAbsolutePath() + " into " + unzipDirectory.getAbsolutePath(), 2);
                try {
                    ZipUtil.uncompress((File)file, (File)unzipDirectory);
                }
                catch (IOException e) {
                    throw new BuildException("Error on unzip archive", (Throwable)e);
                }
                String xmiName = currentFile.getName().substring(0, currentFile.getName().lastIndexOf(46)) + ".xmi";
                currentFile = new File(unzipDirectory, xmiName);
            }
            if (this.isXmiFile(currentFile)) {
                String xmiVersion = this.getXmiVersion(currentFile);
                if (xmiVersion != null) {
                    File outputDirectory = new File(this.buildDirectory, "models");
                    outputDirectory.mkdirs();
                    String modelName = currentFile.getName().substring(0, currentFile.getName().lastIndexOf(46));
                    String propertyPath = currentFile.getParent();
                    File propertyFile = new File(propertyPath, modelName + ".properties");
                    if (propertyFile.exists()) {
                        File propertyOutputFile = new File(outputDirectory, propertyFile.getName());
                        try {
                            FileUtil.copy((File)propertyFile, (File)propertyOutputFile);
                        }
                        catch (IOException ioe) {
                            this.log("Cannot copy .properties file", ioe, 0);
                        }
                    }
                    for (String transformation : transformationsArray) {
                        File outputFile;
                        if (transformation.trim().equalsIgnoreCase("object")) {
                            outputFile = new File(outputDirectory, modelName + ".objectmodel");
                            if (xmiVersion.equals("1.2")) {
                                this.log("Apply XMI 1.2 to object model XSLT on " + currentFile.getAbsolutePath(), 2);
                                this.executeXSLT(currentFile, outputFile, "xmi1.2ToObjectModel.xsl");
                            } else if (xmiVersion.equals("2.1")) {
                                this.log("Apply XMI 2.1 to object model XSLT on " + currentFile.getAbsolutePath(), 2);
                                this.executeXSLT(currentFile, outputFile, "xmi2.1ToObjectModel.xsl");
                            }
                            result.add(outputFile);
                            continue;
                        }
                        if (!transformation.trim().equalsIgnoreCase("state")) continue;
                        outputFile = new File(outputDirectory, modelName + ".statemodel");
                        if (xmiVersion.equals("1.2")) {
                            this.log("Apply XMI 1.2 to state model XSLT on " + currentFile.getAbsolutePath(), 2);
                            this.executeXSLT(currentFile, outputFile, "xmi1.2ToStateModel.xsl");
                        } else if (xmiVersion.equals("2.1")) {
                            throw new BuildException("State model transformation is not supported for xmi 2.1");
                        }
                        result.add(outputFile);
                    }
                    continue;
                }
                throw new BuildException("Can't get xmi version from file : " + currentFile.getAbsolutePath());
            }
            if (!this.isModelFile(currentFile)) continue;
            result.add(currentFile);
        }
        return result;
    }

    protected boolean isArchiveFile(File file) {
        String fileName = file.getName();
        boolean result = fileName.endsWith(".zargo") || fileName.endsWith(".zuml");
        return result;
    }

    protected boolean isXmiFile(File file) {
        String fileName = file.getName();
        boolean result = fileName.endsWith(".uml") || fileName.endsWith(".xmi");
        return result;
    }

    protected boolean isModelFile(File file) {
        String fileName = file.getName();
        boolean result = fileName.endsWith(".objectmodel") || fileName.endsWith(".statemodel");
        return result;
    }

    protected String getXmiVersion(File xmiFile) {
        String version = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            XmiVersionHandler handler = new XmiVersionHandler();
            parser.parse(xmiFile, (DefaultHandler)handler);
            version = handler.getVersion();
        }
        catch (ParserConfigurationException e) {
            this.log("Can't parse file as xmi", e, 4);
        }
        catch (SAXException e) {
            this.log("Can't parse file as xmi", e, 4);
        }
        catch (IOException e) {
            this.log("Can't parse file as xmi", e, 4);
        }
        return version;
    }

    protected void executeXSLT(File xmiFile, File modelFile, String stylesheet) {
        try {
            Iterator<TransformerFactory> itTransformerFactory = ServiceLoader.load(TransformerFactory.class).iterator();
            if (!itTransformerFactory.hasNext()) {
                throw new BuildException("No XSLT Transformer found");
            }
            TransformerFactory transformerFactory = itTransformerFactory.next();
            URL uxsl = Resource.getURL((String)stylesheet);
            StreamSource stylesource = new StreamSource(uxsl.openStream());
            Transformer transformer = transformerFactory.newTransformer(stylesource);
            if (this.properties.containsKey("fullPackagePath")) {
                transformer.setParameter("fullPackagePath", this.properties.getProperty("fullPackagePath"));
            }
            if (this.properties.containsKey("extraPackages")) {
                transformer.setParameter("extraPackages", this.properties.getProperty("extraPackages"));
            }
            if (this.resolver != null && !this.resolver.isEmpty()) {
                Class<?> clazz = Class.forName(this.resolver);
                URIResolver tresolver = null;
                try {
                    Constructor<?> withBaseConstructor = clazz.getConstructor(String.class);
                    String base = xmiFile.getParentFile().getAbsolutePath();
                    tresolver = (URIResolver)withBaseConstructor.newInstance(base);
                }
                catch (Exception eee) {
                    this.log("Unable to instantiate resolver with String parameter", eee, 1);
                }
                if (tresolver == null) {
                    tresolver = (URIResolver)clazz.newInstance();
                }
                transformer.setURIResolver(tresolver);
            }
            transformer.transform(new StreamSource(xmiFile.getAbsolutePath()), new StreamResult(modelFile.getAbsolutePath()));
        }
        catch (TransformerException e) {
            throw new BuildException("Transformation exception (xslt)", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new BuildException("Invalid jar url", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BuildException("Can't init resolver", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Can't access resolver", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Can't find resolver", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("Error while trying to access stylesheet", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new BuildException("Error while trying to access stylesheet", (Throwable)e);
        }
    }

    protected class XmiVersionHandler
    extends DefaultHandler {
        public String version;

        public String getVersion() {
            return this.version;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("XMI")) {
                this.version = attributes.getValue("xmi.version");
                GeneratorTask.this.log("XMI version found : " + this.version, 4);
            }
            if (this.version == null) {
                this.version = attributes.getValue("xmi:version");
                GeneratorTask.this.log("XMI version found : " + this.version, 4);
            }
        }
    }
}

