/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.search;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.chorem.vradi.services.search.FilterList;
import org.chorem.vradi.services.search.FilterListQueryHandler;
import org.chorem.vradi.services.search.LuceneQueryParser;
import org.chorem.vradi.services.search.QueryHandler;
import org.chorem.vradi.services.search.UnsupportedQueryException;

public class VradiQueryParser {
    private static final Log log = LogFactory.getLog(VradiQueryParser.class);
    public static final String DEFAULT_FIELD = "text";

    public static FilterList parse(String expression) throws UnsupportedQueryException {
        return VradiQueryParser.parse(expression, DEFAULT_FIELD);
    }

    public static FilterList parse(String expression, String defaultField) throws UnsupportedQueryException {
        FilterListQueryHandler queryHandler = new FilterListQueryHandler();
        VradiQueryParser.parse(queryHandler, expression, defaultField);
        FilterList filterList = queryHandler.getFilterList();
        return filterList;
    }

    static void parse(QueryHandler queryHandler, String expression, String defaultField) throws UnsupportedQueryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("expression: " + expression));
        }
        Version lucene31 = Version.LUCENE_31;
        WhitespaceAnalyzer analyzer = new WhitespaceAnalyzer(lucene31);
        QueryParser parser = new QueryParser(lucene31, defaultField, (Analyzer)analyzer);
        parser.setAllowLeadingWildcard(true);
        parser.setDefaultOperator(QueryParser.Operator.AND);
        if (expression == null || expression.trim().isEmpty()) {
            expression = defaultField + ":*";
        }
        try {
            Query query = parser.parse(expression.trim());
            LuceneQueryParser luceneQueryParser = new LuceneQueryParser(queryHandler);
            luceneQueryParser.parse(query);
        }
        catch (ParseException e) {
            throw new UnsupportedQueryException(expression, e);
        }
    }
}

