/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.chorem.vradi.services.search.Filter;

public class FilterList
implements Filter {
    private static final long serialVersionUID = 1L;
    protected Operator operator;
    protected List<Filter> filters;

    public FilterList() {
        this(Operator.FILTER_AND);
    }

    public FilterList(Operator operator) {
        this.operator = operator;
        this.filters = new ArrayList<Filter>();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public boolean addFilter(Filter filter) {
        return this.filters.add(filter);
    }

    public static enum Operator {
        FILTER_AND,
        FILTER_OR,
        FILTER_NOT;


        public static Operator getOperator(BooleanClause booleanClause) {
            Operator operator = null;
            operator = booleanClause != null && booleanClause.isProhibited() ? FILTER_NOT : (booleanClause != null && booleanClause.isRequired() ? FILTER_AND : FILTER_OR);
            return operator;
        }

        public String getValue() {
            String luceneOperator = null;
            switch (this) {
                case FILTER_NOT: {
                    luceneOperator = "NOT";
                    break;
                }
                case FILTER_AND: {
                    luceneOperator = "AND";
                    break;
                }
                case FILTER_OR: {
                    luceneOperator = "OR";
                }
            }
            return luceneOperator;
        }
    }
}

