/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiServiceConfigurationHelper;
import org.chorem.vradi.entities.Form;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyServiceDelegator;

public class VradiPDFCleanerService
extends WikittyServiceDelegator {
    private static final Log log = LogFactory.getLog(VradiPDFCleanerService.class);
    protected ApplicationConfig config;

    public VradiPDFCleanerService(WikittyService delegate, ApplicationConfig config) {
        super(delegate);
        this.config = config;
    }

    public static File getGeneratedPdfFile(Form form, ApplicationConfig config) {
        String filename = form.getWikittyId() + "-" + form.getWikittyVersion() + ".pdf";
        File pdfDir = VradiServiceConfigurationHelper.getPdfDir(config);
        File result = new File(pdfDir, filename);
        return result;
    }

    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        WikittyEvent event = super.storeExtension(securityToken, exts);
        for (WikittyExtension ext : exts) {
            if (!"Form".equals(ext.getRequires())) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Removing generated pdf for extension " + ext.getName()));
            }
            Search search = Search.query().eq(Element.ELT_EXTENSION, ext.getName());
            Criteria criteria = search.criteria();
            List allFormId = this.findAllByCriteria(securityToken, Arrays.asList(criteria));
            if (!CollectionUtils.isNotEmpty((Collection)allFormId)) continue;
            for (String formId : ((PagedResult)allFormId.get(0)).getAll()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delete all pdf files for form " + formId));
                }
                File generatedPdfDir = VradiServiceConfigurationHelper.getPdfDir(this.config);
                String filePattern = Pattern.quote(formId) + ".*\\.pdf";
                List pdfFiles = FileUtil.find((File)generatedPdfDir, (String)filePattern, (boolean)false);
                for (File pdfFile : pdfFiles) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Delete pdf file " + pdfFile));
                    }
                    pdfFile.delete();
                }
            }
        }
        return event;
    }
}

