/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.chorem.vradi.entities.Form;

public class FormPagedResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    public static final String FORMS_TO_SHOW_PROPERTY = "formsToShow";
    public static final String TOTAL_FOUND_FORM_NB_PROPERTY = "totalFoundFormNb";
    public static final String PAGE_TO_SHOW_PROPERTY = "pageToShow";
    public static final String NB_FORMS_TO_SHOW_PROPERTY = "nbFormsToShow";
    public static final String FIELD_TO_SORT_PROPERTY = "fieldToSort";
    public static final String ASCENDING_PROPERTY = "ascending";
    protected List<String> formsIdsToShow = new ArrayList<String>();
    protected int totalFoundFormNb = 0;
    protected int pageToShow = 0;
    protected int nbFormsToShow = 0;
    protected String fieldToSort = null;
    protected boolean ascending = true;

    public FormPagedResult() {
    }

    public FormPagedResult(List<Form> formsToShow) {
        this(formsToShow, formsToShow.size(), 0, formsToShow.size());
    }

    public FormPagedResult(List<Form> formsToShow, int totalFoundFormNb, int pageToShow, int nbFormsToShow) {
        this();
        this.formsIdsToShow = this.extractIds(formsToShow);
        this.totalFoundFormNb = totalFoundFormNb;
        this.pageToShow = pageToShow;
        this.nbFormsToShow = nbFormsToShow;
    }

    protected List<String> extractIds(List<Form> formsToShow) {
        ArrayList<String> formsIds = new ArrayList<String>();
        if (formsToShow != null) {
            for (Form form : formsToShow) {
                if (form == null) continue;
                formsIds.add(form.getWikittyId());
            }
        }
        return formsIds;
    }

    public List<String> getFormsIdsToShow() {
        return this.formsIdsToShow;
    }

    public void setFormsToShow(List<String> formsIdsToShow) {
        List<String> oldValue = this.formsIdsToShow;
        this.formsIdsToShow = formsIdsToShow;
        this.propertyChange.firePropertyChange(FORMS_TO_SHOW_PROPERTY, oldValue, formsIdsToShow);
    }

    public int getTotalFoundFormNb() {
        return this.totalFoundFormNb;
    }

    public void setTotalFoundFormNb(int totalFoundFormNb) {
        int oldValue = this.totalFoundFormNb;
        this.totalFoundFormNb = totalFoundFormNb;
        this.propertyChange.firePropertyChange(TOTAL_FOUND_FORM_NB_PROPERTY, oldValue, totalFoundFormNb);
    }

    public int getPageToShow() {
        return this.pageToShow;
    }

    public void setPageToShow(int pageToShow) {
        int oldValue = this.pageToShow;
        this.pageToShow = pageToShow;
        this.propertyChange.firePropertyChange(PAGE_TO_SHOW_PROPERTY, oldValue, pageToShow);
    }

    public int getNbFormsToShow() {
        return this.nbFormsToShow;
    }

    public void setNbFormsToShow(int nbFormsToShow) {
        int oldValue = this.nbFormsToShow;
        this.nbFormsToShow = nbFormsToShow;
        this.propertyChange.firePropertyChange(NB_FORMS_TO_SHOW_PROPERTY, oldValue, nbFormsToShow);
    }

    public String getFieldToSort() {
        return this.fieldToSort;
    }

    public void setFieldToSort(String fieldToSort) {
        String oldValue = this.fieldToSort;
        this.fieldToSort = fieldToSort;
        this.propertyChange.firePropertyChange(FIELD_TO_SORT_PROPERTY, oldValue, fieldToSort);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        boolean oldValue = this.ascending;
        this.ascending = ascending;
        this.propertyChange.firePropertyChange(ASCENDING_PROPERTY, oldValue, ascending);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(propertyName, listener);
    }
}

