/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiTestConfiguration;
import org.chorem.vradi.beans.FormPagedResult;
import org.chorem.vradi.beans.QueryParameters;
import org.chorem.vradi.beans.XmlStreamImportResult;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.ClientImpl;
import org.chorem.vradi.entities.FieldTypeEnum;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.GroupImpl;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.StatusImpl;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.entities.ThesaurusImpl;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.entities.UserImpl;
import org.chorem.vradi.entities.XmlFieldBinding;
import org.chorem.vradi.entities.XmlFieldBindingImpl;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.entities.XmlStreamImpl;
import org.chorem.vradi.services.FileService;
import org.chorem.vradi.services.FileServiceImpl;
import org.chorem.vradi.services.ServiceFactory;
import org.chorem.vradi.services.VradiDataService;
import org.chorem.vradi.services.VradiDataServiceImpl;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiStorageService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.Resource;
import org.nuiton.util.converter.ConverterUtil;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;

public abstract class VradiTestAbstract {
    private static final Log log = LogFactory.getLog(VradiTestAbstract.class);
    protected ApplicationConfig config;
    protected WikittyProxy wikittyProxy;
    protected VradiDataService dataService;
    protected VradiStorageService storageService;
    protected FileService fileService;

    @BeforeClass
    public static void initConfig() {
        ConverterUtil.initConverters();
        ApplicationConfig instance = VradiTestConfiguration.getConfig();
        String tmpdir = System.getProperty("java.io.tmpdir");
        File file = new File(tmpdir);
        if (!file.exists()) {
            file.mkdirs();
        }
        File dataDirectory = new File(tmpdir, "wikitty-data-store");
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use data directory : " + dataDirectory));
        }
        instance.setOption(WikittyConfigOption.WIKITTY_DATA_DIR.key, dataDirectory.getAbsolutePath());
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating tmp dir : " + file));
        }
    }

    @Before
    public void clear() throws Exception {
        log.debug((Object)"--clear-----------------------------------------");
        this.config = VradiTestConfiguration.getConfig();
        this.storageService = ServiceFactory.getVradiStorageService();
        this.wikittyProxy = ServiceFactory.getWikittyProxy();
        this.wikittyProxy.clear();
        this.dataService = new VradiDataServiceImpl(this.config, this.wikittyProxy);
        this.fileService = new FileServiceImpl(this.config);
    }

    protected WikittyExtension createFileFormType() throws VradiException {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("name", FieldTypeEnum.STRING.getFieldType());
        fields.put("dir", FieldTypeEnum.STRING.getFieldType());
        fields.put("size", FieldTypeEnum.NUMERIC.getFieldType());
        fields.put("lastModified", FieldTypeEnum.DATE_TIME.getFieldType());
        fields.put("modified", FieldTypeEnum.STRING.getFieldType());
        fields.put("description", FieldTypeEnum.TEXT.getFieldType());
        return this.createFormType("file", fields);
    }

    protected WikittyExtension createAnnonceFormType() throws VradiException {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("acheteur", FieldTypeEnum.STRING.getFieldType());
        fields.put("date", FieldTypeEnum.STRING.getFieldType());
        fields.put("departement", FieldTypeEnum.STRING.getFieldType());
        fields.put("description", FieldTypeEnum.STRING.getFieldType());
        fields.put("intitule", FieldTypeEnum.STRING.getFieldType());
        return this.createFormType("annonce", fields);
    }

    protected WikittyExtension createDatesFormType() throws VradiException {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("id", FieldTypeEnum.STRING.getFieldType());
        fields.put("date", FieldTypeEnum.DATE_TIME.getFieldType());
        return this.createFormType("dates", fields);
    }

    protected WikittyExtension createFormType(String name, Map<String, FieldType> fields) throws VradiException {
        WikittyExtension extension = this.dataService.getFormType(name);
        if (extension == null) {
            extension = this.dataService.updateFormType(name, fields, "Form", null);
        }
        return extension;
    }

    protected List<XmlFieldBinding> createXmlBindings(WikittyExtension extension) throws Exception {
        ArrayList<XmlFieldBinding> bindings = new ArrayList();
        String name = extension.getName();
        Collection fieldNames = extension.getFieldNames();
        for (String field : fieldNames) {
            XmlFieldBindingImpl binding = new XmlFieldBindingImpl();
            binding.setFormField(name + "." + field);
            binding.addXmlField(field);
            bindings.add((XmlFieldBinding)binding);
        }
        bindings = this.dataService.updateXmlFieldBindings(bindings);
        return bindings;
    }

    protected XmlStream createXmlStream(WikittyExtension extension, List<XmlFieldBinding> bindings, URL resource) throws Exception {
        XmlStreamImpl stream = new XmlStreamImpl();
        stream.setName(extension.getId());
        stream.setFormTypeName(extension.getName());
        log.info((Object)("Setting xmlStream url to: " + resource.toExternalForm()));
        stream.setUrl(resource.toExternalForm());
        for (XmlFieldBinding fieldBinding : bindings) {
            stream.addXmlFieldBinding(fieldBinding.getWikittyId());
        }
        BusinessEntity updateEntity = this.wikittyProxy.store((BusinessEntity)stream);
        return (XmlStream)updateEntity;
    }

    protected XmlStream createXmlStream(WikittyExtension extension, List<XmlFieldBinding> bindings) throws Exception {
        String url = "/" + extension.getName() + ".xml";
        URL resource = Resource.getURL((String)url);
        return this.createXmlStream(extension, bindings, resource);
    }

    protected Status createSatus(String name, String description, int value, boolean modifiable) throws Exception {
        StatusImpl status = new StatusImpl();
        status.setName(name);
        status.setDescription(description);
        status.setValue(value);
        status.setModifiable(modifiable);
        BusinessEntity updateEntity = this.wikittyProxy.store((BusinessEntity)status);
        return (Status)updateEntity;
    }

    protected Client createClient(String name, String ... queries) throws Exception {
        ClientImpl client = new ClientImpl();
        client.setName(name);
        client = (Client)this.wikittyProxy.store((BusinessEntity)client);
        return client;
    }

    protected User createUser(String name, String ... queries) throws Exception {
        UserImpl user = new UserImpl();
        user.setName(name);
        user = (User)this.wikittyProxy.store((BusinessEntity)user);
        return user;
    }

    protected Group createGroup(String name, String ... queries) throws Exception {
        GroupImpl group = new GroupImpl();
        for (String query : queries) {
            group.addQueries(query);
        }
        group.setName(name);
        group = (Group)this.wikittyProxy.store((BusinessEntity)group);
        return group;
    }

    protected WikittyExtension createThesaurusExtension() throws Exception {
        WikittyExtension thesaurusExtension = ThesaurusImpl.extensionThesaurus;
        thesaurusExtension = this.dataService.updateFormType(thesaurusExtension);
        return thesaurusExtension;
    }

    protected Thesaurus createThesaurus(String name, RootThesaurus rootThesaurus, String ... tags) throws Exception {
        return this.createThesaurus(name, null, rootThesaurus, tags);
    }

    protected Thesaurus createThesaurus(String name, String parent, RootThesaurus rootThesaurus, String ... tags) throws Exception {
        ThesaurusImpl result = new ThesaurusImpl();
        result.setName(name);
        result.setParent(parent);
        result.setRootThesaurus(rootThesaurus.getWikittyId());
        if (tags != null) {
            for (String tag : tags) {
                result.addTags(tag);
            }
        }
        result = (Thesaurus)this.wikittyProxy.store((BusinessEntity)result);
        return result;
    }

    protected void testSearch(String query, int count) throws Exception {
        FormPagedResult testSearch = this.testSearch(query);
        Assert.assertEquals((long)count, (long)testSearch.getTotalFoundFormNb());
    }

    protected FormPagedResult testSearch(String query) throws Exception {
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters(query);
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        if (log.isTraceEnabled()) {
            this.traceFormsFound(formPagedResult);
        }
        return formPagedResult;
    }

    protected void testSearch(Status[] statuses, int count) throws Exception {
        FormPagedResult testSearch = this.testSearch(statuses);
        Assert.assertEquals((long)count, (long)testSearch.getTotalFoundFormNb());
    }

    protected FormPagedResult testSearch(Status[] statuses) throws Exception {
        ArrayList<String> statusIds = null;
        if (statuses != null) {
            statusIds = new ArrayList<String>(statuses.length);
            for (int i = 0; i < statuses.length; ++i) {
                statusIds.add(statuses[i].getWikittyId());
            }
        }
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters();
        queryParameters.setStatusIds(statusIds);
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        if (log.isTraceEnabled()) {
            this.traceFormsFound(formPagedResult);
        }
        return formPagedResult;
    }

    protected void traceFormsFound(FormPagedResult formPageDTO) {
        List formsIds = formPageDTO.getFormsIdsToShow();
        List forms = this.wikittyProxy.restore(Form.class, formsIds);
        for (Form form : forms) {
            Collection extensions = form.getExtensionNames();
            log.trace((Object)form.getWikittyId());
            for (String extension : extensions) {
                Collection extensionFields = form.getExtensionFields(extension);
                for (String field : extensionFields) {
                    log.trace((Object)String.format("  %s: %.100s", field, form.getField(extension, field)));
                }
            }
        }
    }

    protected XmlStreamImportResult initData(WikittyExtension extension) throws Exception {
        List<XmlFieldBinding> bindings = this.createXmlBindings(extension);
        XmlStream xmlStream = this.createXmlStream(extension, bindings);
        return this.storageService.importFormsFromXmlStream(xmlStream);
    }
}

