/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: AutoSendTasks.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-services/src/main/java/org/chorem/vradi/services/tasks/AutoSendTasks.java $
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.services.tasks;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.managers.FormManager;
import org.chorem.vradi.services.managers.MailingManager;

import java.util.TimerTask;

/**
 * @author sletellier
 */
public class AutoSendTasks extends TimerTask {

    private static final Log log = LogFactory.getLog(AutoSendTasks.class);


    protected FormManager formManager;
    protected MailingManager mailingManager;

    public AutoSendTasks(FormManager formManager, MailingManager mailingManager) {
        this.formManager = formManager;
        this.mailingManager = mailingManager;
    }

    @Override
    public void run() {

        try {
            // Get open session of open
            Session session = formManager.getLastOpenSession();

            // If no session is opened, creating new one
            if (session == null) {
                session = formManager.createNewSession();
            }

            // Bind all forms
            session= formManager.bindForms(session);

            String sessionId = session.getWikittyId();

            // Generate pdf for session
            mailingManager.generatePDFForSession(sessionId);

            // Send email for session
            String logs = mailingManager.sendMessages(sessionId);

            log.info("Send email is finished : " + logs);

        } catch (VradiException e) {
            log.error("Failled to auto send session");
        }
    }
}
