/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: RangeFilter.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-services/src/main/java/org/chorem/vradi/services/search/RangeFilter.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.services.search;

import org.apache.commons.lang.math.NumberUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * RangeFilter.
 *
 * @author $Author: sletellier $
 * @version $Revision: 21 $ $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 * @since 4 mars 2010 10:38:16
 */
public class RangeFilter extends CompareFilter {
    private static final long serialVersionUID = 1L;

    protected String lowerValue = null;

    protected String upperValue = null;

    public RangeFilter(String term, String lowerValue, String upperValue) {
        super(term, lowerValue);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        lowerValue = value;
    }

    public void setLowerValue(String value) {
        lowerValue = value;
    }

    public String getLowerValue() {
        return lowerValue;
    }

    public void setUpperValue(String value) {
        upperValue = value;
    }

    public String getUpperValue() {
        return upperValue;
    }

    @Override
    public boolean isNumber() {
        return NumberUtils.isNumber(lowerValue) && NumberUtils.isNumber(upperValue);
    }

    @Override
    public boolean match(Pattern pattern) {
        Matcher lowerMatcher = pattern.matcher(lowerValue);
        Matcher upperMatcher = pattern.matcher(upperValue);
        return lowerMatcher.matches() && upperMatcher.matches();
    }

    @Override
    public String toString() {
        return String.format("%s = [%s TO %s]", term, lowerValue, upperValue);
    }
}
