/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: QueryParameters.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-services/src/main/java/org/chorem/vradi/beans/QueryParameters.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.vradi.beans;

import org.chorem.vradi.entities.Thesaurus;
import org.nuiton.wikitty.entities.WikittyExtension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Query parameters.
 * <p/>
 * The {@link #beginDate} and {@link #endDate} specifies a
 * date range filter which is applied on {@link #dateFieldName} field.
 * The date range filter is applied only if the three parameters are not null.
 *
 * @author chatellier
 * @version $Revision: 21 $
 *          <p/>
 *          Last update : $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 *          By : $Author: sletellier $
 */
public class QueryParameters implements Serializable {

    /** serialVersionUID */
    private static final long serialVersionUID = 1L;

    protected String query;

    protected Date beginDate;

    protected Date endDate;

    protected WikittyExtension extension;

    protected String dateFieldName;

    protected List<String> statusIds;

    protected List<Thesaurus> thesaurus;

    protected List<String> streamIds;

    public QueryParameters() {

    }

    public QueryParameters(String query) {
        this();
        this.query = query;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public WikittyExtension getExtension() {
        return extension;
    }

    public void setExtension(WikittyExtension extension) {
        this.extension = extension;
    }

    public String getDateFieldName() {
        return dateFieldName;
    }

    public void setDateFieldName(String dateFieldName) {
        this.dateFieldName = dateFieldName;
    }

    public List<String> getStatusIds() {
        return statusIds;
    }

    public void setStatusIds(List<String> statusIds) {
        this.statusIds = statusIds;
    }

    public List<Thesaurus> getThesaurus() {
        return thesaurus;
    }

    public void setThesaurus(List<Thesaurus> thesaurus) {
        this.thesaurus = thesaurus;
    }

    public void addThesaurus(Thesaurus thesaurus) {
        if (this.thesaurus == null) {
            this.thesaurus = new ArrayList<Thesaurus>();
        }
        this.thesaurus.add(thesaurus);
    }

    public void clearThesaurus() {
        if (thesaurus != null) {
            thesaurus.clear();
        }
    }

    public List<String> getStreamIds() {
        return streamIds;
    }

    public void setStreamIds(List<String> streamIds) {
        this.streamIds = streamIds;
    }
}
