/*
 * #%L
 * Pollen :: VoteCounting strategy :: Borda
 * $Id: BordaVoteCountingStrategy.java 3710 2012-09-29 21:18:12Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.4/pollen-votecounting-borda/src/main/java/org/chorem/pollen/votecounting/BordaVoteCountingStrategy.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.Voter;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Condorcet.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class BordaVoteCountingStrategy extends AbstractVoteCountingStrategy {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(BordaVoteCountingStrategy.class);

    @Override
    public VoteCountingResult votecount(Set<Voter> voters) {

        // get empty result by choice
        Map<String, ChoiceScore> scores = newEmptyChoiceScoreMap(voters);

        // nb of choices
        int nbChoices = scores.keySet().size();

        if (log.isDebugEnabled()) {
            log.debug("Nb choices: " + nbChoices);
        }

        // calcul pour chaque votant de sa liste des choix dans son ordre préféré

        Map<Voter, List<Set<String>>> voterSortedChoices =
                buildVoterSortedChoices(voters);

        // calcul des points pour chaque choix selon son ordre d'arrivé (
        // le 1er à nbChoices * weight point, le second (nbChoices-1) * weight,...)

        for (Map.Entry<Voter, List<Set<String>>> entry : voterSortedChoices.entrySet()) {
            Voter voter = entry.getKey();
            double weight = voter.getWeight();
            double choiceWeight = nbChoices * weight;
            for (Set<String> sortedChoiceId : entry.getValue()) {

                for (String choiceId : sortedChoiceId) {

                    scores.get(choiceId).addScoreValue(choiceWeight);
                }
                choiceWeight -= weight;
            }
        }

        // order scores (using their value) and return result
        VoteCountingResult result = orderByValues(scores.values());
        return result;
    }
}
