/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: ExportPoll.java 3712 2012-09-30 12:57:25Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/admin/ExportPoll.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.admin;

import org.apache.commons.io.IOUtils;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;

import java.io.InputStream;

/**
 * Exports an existing poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ExportPoll extends PollenActionSupport implements PollenUserSecurityAware {

    private static final long serialVersionUID = 1L;

    protected String filename;

    protected long contentLength;

    protected transient InputStream inputStream;

    public long getContentLength() {
        return contentLength;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public String getFilename() {
        return filename;
    }

    @Override
    public String execute() throws Exception {

        String pollId = getUserSecurityContext().getPoll().getPollId();

        String exportContent = getPollExportService().exportToXml(pollId);

        filename = "exportPoll-" + pollId + ".xml";

        contentLength = exportContent.length() * 2;

        inputStream = IOUtils.toInputStream(exportContent);

        return SUCCESS;
    }
}
