/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.security;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.ui.PollenUIUtils;
import org.chorem.pollen.ui.security.AbstractPollenAuthorization;
import org.nuiton.i18n.I18n;

public class PollCreatorAccessRequired
extends AbstractPollenAuthorization {
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        PollenUserSecurityContext securityContext = this.createSecurityContext(request);
        boolean isAccessAllowed = securityContext.isPollExists();
        if (isAccessAllowed && securityContext.isWithAccountId() && securityContext.hasNoRole()) {
            isAccessAllowed = false;
            this.registerError(request, I18n.n_((String)"pollen.security.error.bad.accountId", (Object[])new Object[0]));
        }
        if (isAccessAllowed && !securityContext.isCreator()) {
            isAccessAllowed = false;
            this.registerError(request, I18n.n_((String)"pollen.security.error.creatorId.or.admin.required", (Object[])new Object[0]));
        }
        if (isAccessAllowed) {
            PollenUIUtils.setUserSecuritycontext((ServletRequest)request, (PollenUserSecurityContext)securityContext);
        }
        return isAccessAllowed;
    }
}

