<%--
  #%L
  Pollen :: UI (struts2)
  $Id: result.jsp 3714 2012-10-01 04:06:59Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.4/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/poll/result.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page contentType="text/html" language="java" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/results.css'/>"/>
<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/pollInformation.css'/>"/>
<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/jquery.lightbox-0.5.css'/>"/>


<script type="text/javascript"
        src="<s:url value='/js/jquery.lightbox-0.5.js' />"></script>

<script type="text/javascript">

  function displayCharts(type) {
    $.each(chartUrls, function (key, value) {
      var url = value + "&type=" + type;
      $('#' + key).attr("src", url);
    });
    return false;
  }

  var chartUrls = {};

  chartUrls['chart_normal'] = "<s:url value='%{getNormalPollResultChartUrl(400, 300)}' escapeAmp='false'/>";
  <s:if test="byGroup">
  //Add all result by group
  <s:iterator value="groupIds" var="groupId" status="status">
  chartUrls['chart_Group_<s:property value="#status.index"/>'] = "<s:url value='%{getGroupPollResultChartUrl(#groupId, 400, 300)}' escapeAmp='false'/>";
  </s:iterator>
  </s:if>
  <%--<s:if test="numberVoteCounting">--%>
  <%--<s:iterator value="choicesResultNames" var="choicesResultName" status="status">--%>
  <%--chartUrls['chart_<s:property value="#status.index"/>'] = "<s:url value='%{getChoicesResultCharUrl(400,300, #choicesResultName)}' escapeAmp='false'/>";--%>
  <%--</s:iterator>--%>
  <%--</s:if>--%>

  jQuery(document).ready(function () {

    // register all chart url (without the type in it)
    displayCharts(1);

    $('a[rel*="lightbox"]').lightBox(
      {
        imageLoading:'<s:url value="/img/lightbox-ico-loading.gif"/>',
        imageBtnClose:'<s:url value="/img/lightbox-btn-close.gif"/>',
        imageBtnPrev:'<s:url value="/img/lightbox-btn-prev.gif"/>',
        imageBtnNext:'<s:url value="/img/lightbox-btn-next.gif"/>'
      });

  });
</script>

<h1 class="titleVoteCounting"><s:property value="poll.title"/></h1>

<%-- Informations sur le sondage --%>
<s:set name="showVoteUrl" value="true"/>
<s:set name="showResultUrl" value="false"/>
<%@include file="pollInformation.jsp" %>

<h4>
  <s:property value="%{voteSizeMessage}"/>
</h4>

<%-- Victoire --%>
<h4><s:property value="victoryMessage"/>
  <br/>
  <s:iterator value="pollResult.topRanking" var="result">
    <s:set name="choiceName" value="%{getChoiceName(#result.choiceId)}"/>
    <s:if test="textType">
      <s:property value="%{#choiceName}"/>
    </s:if>
    <s:elseif test="dateType">
      <s:property value="%{getResultAsDate(#choiceName)}"/>
    </s:elseif>
    <s:elseif test="imageType">
      <s:url id="imageUrl" namespace="/io" action="getPollChoiceImage"
             escapeAmp="false">
        <s:param name="choiceId" value="%{#choiceName}"/>
        <s:param name="pollId" value="poll.pollId"/>
        <s:param name="thumb" value="false"/>
      </s:url>
      <s:url id="imageUrlThumb" namespace="/io" action="getPollChoiceImage"
             escapeAmp="false">
        <s:param name="choiceId" value="%{#choiceName}"/>
        <s:param name="pollId" value="poll.pollId"/>
        <s:param name="thumb" value="true"/>
      </s:url>
      <a href="<s:property value='imageUrl'/>" rel="lightbox">
        <img alt="<s:property value='%{#choiceName}'/>"
             title="<s:property value='%{#choiceName}'/>"
             src="<s:property value='imageUrlThumb'/>">
      </a>

    </s:elseif>
    <br/>
  </s:iterator>
</h4>

<%-- Diagramme --%>
<div id="resultChart">
  <div class="chartTypeDiv">
    <sj:a id='displayChart1' href="#" onclick="return displayCharts(1);">
      <img src="<s:url value='/img/rep1.png'/>"
           title='<s:text name="pollen.common.chartType-pie"/>' alt="1"/>
    </sj:a>
    <sj:a id='displayChart2' href="#" onclick="return displayCharts(2);">
      <img src="<s:url value='/img/rep2.png'/>"
           title='<s:text name="pollen.common.chartType-pie3d"/>' alt="2"/>
    </sj:a>
    <sj:a id='displayChart3' href="#" onclick="return displayCharts(3);">
      <img src="<s:url value='/img/rep3.png'/>"
           title='<s:text name="pollen.common.chartType-ring"/>' alt="3"/>
    </sj:a>
  </div>

  <div class="displayTypeDiv">
    <s:if test="poll.pollGroup">
      <s:text name="pollen.common.results"/>
      <s:if test="byGroup">
        <s:a href="%{getResultUrl(false)}">
          <s:text name="pollen.common.normal"/>
        </s:a>
        - <s:text name="pollen.common.group"/>
      </s:if>
      <s:else>
        <s:text name="pollen.common.normal"/> -
        <s:a href="%{getResultUrl(true)}">
          <s:text name="pollen.common.group"/>
        </s:a>
      </s:else>
    </s:if>
  </div>

  <sj:div id='chartContainer'>
    <img id='chart_normal'/>
  </sj:div>

  <%-- result by group --%>
  <s:if test="byGroup">
    <div id="resultChart">
      <div>
        <s:iterator value="groupIds" var="groupId" status="status">
          <hr/>
          <s:set name="groupName" value="%{getGroupName(#groupId)}"/>
          <img id='chart_Group_<s:property value="#status.index"/>'
               alt="<s:property value='%{#groupName}'/>"
               title="<s:property value='%{#groupName}'/>"/>
        </s:iterator>
      </div>
      <br/>
    </div>
  </s:if>

  <%-- Diagramme par choix --%>
  <%--<s:if test="choicesResults != null">--%>
  <%--<div id="resultChart">--%>
  <%--<div>--%>
  <%--<s:iterator value="choicesResultNames" var="choicesResultName"--%>
  <%--status="status">--%>
  <%--<img id='chart_<s:property value="#status.index"/>'--%>
  <%--alt="<s:property/>" title="<s:property/>"--%>
  <%--src="<s:property value='%{getChoicesResultCharUrl(400,300, #choicesResultName)}'/>">--%>
  <%--</s:iterator>--%>
  <%--</div>--%>
  <%--</div>--%>
  <%--</s:if>--%>
</div>
<!-- Classement -->
<%--<t:remove>--%>
<%--<div id="resultList">--%>
<%--<ol>--%>
<%--<s:iterator value="ranking" var="result">--%>
<%--<li>--%>
<%--<s:if test="dateType">--%>
<%--<s:property value="%{getResultNameAsDate(#result.name)}"/>--%>
<%--&lt;%&ndash;<t:output value="resultNameAsDate" format="dateFormat"/>&ndash;%&gt;--%>
<%--</s:if>--%>
<%--<s:else>--%>
<%--<s:property value="name"/>--%>
<%--</s:else>--%>
<%--(<s:property value="%{getTrimValue(#result)}"/>)--%>
<%--</li>--%>
<%--</s:iterator>--%>
<%--</ol>--%>
<%--</div>--%>
<%--</t:remove>--%>

