/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.ui.actions.json.AbstractJSONPaginedAction;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;

public class GetParticipatedPolls
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, Object>[] data;

    public Map<String, Object>[] getData() {
        return this.data;
    }

    public String execute() throws Exception {
        PollService pollService = this.getPollService();
        List participatedPolls = pollService.getParticipatedPolls(this.pager, this.getPollenUserAccount());
        this.data = new Map[participatedPolls.size()];
        TopiaEntityBinder binder = PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;
        for (Pair entry : participatedPolls) {
            Poll poll = (Poll)entry.getKey();
            Map map = pollService.pollToMap(poll, (Binder)binder);
            PollAccount account = (PollAccount)entry.getValue();
            PollUri pollUri = PollUri.newPollUri((String)poll.getPollId(), (String)account.getAccountId());
            map.put("voteId", pollUri.getUri());
            String resultId = poll.isPollFree() ? pollUri.getPollId() : pollUri.getUri();
            map.put("resultId", resultId);
            map.put("adminId", poll.getAdminId());
            Set functions = this.getPollFunctions(poll, pollUri);
            map.put("functions", functions);
            this.data[index++] = map;
        }
        return "success";
    }

    private Set<String> getPollFunctions(Poll poll, PollUri pollUri) {
        HashSet result = Sets.newHashSet();
        PollenUserSecurityContext securityContext = PollenUserSecurityContext.newContext((UserAccount)this.getPollenUserAccount(), (PollUri)pollUri, (Poll)poll);
        SecurityService securityService = this.getSecurityService();
        securityContext.loadUserRoles(securityService);
        result.add("vote");
        boolean canAccessResult = securityService.isCanAccessResult(securityContext);
        if (canAccessResult) {
            result.add("result");
        } else {
            result.add("noresult");
        }
        boolean canAdminResult = securityContext.isCreator();
        if (canAdminResult) {
            result.add("summary");
        }
        return result;
    }
}

