/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: PollResultAccessRequired.java 3611 2012-08-13 14:11:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.2/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/security/PollResultAccessRequired.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.security;

import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.ui.PollenUIUtils;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import static org.nuiton.i18n.I18n.n_;

/**
 * Check that a user can show results of a poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class PollResultAccessRequired extends AbstractPollenAuthorization {

    @Override
    protected boolean isAccessAllowed(ServletRequest request,
                                      ServletResponse response,
                                      Object mappedValue) {

        PollenUserSecurityContext securityContext =
                createSecurityContext(request);

        boolean isAccessAllowed = securityContext.isPollExists();

        if (isAccessAllowed) {

            // pollId is sane (poll exists from it)

            if (securityContext.isWithAccountId()) {

                // check accountId is sane

                if (securityContext.hasNoRole()) {

                    // bad accountId
                    isAccessAllowed = false;
                    registerError(
                            request,
                            n_("pollen.security.error.bad.accountId"));
                }
            }
        }

        if (isAccessAllowed) {

            // pollId is sane
            // accountId is sane

            // check now poll results can be displayed

            SecurityService securityService = getSecurityService(request);

            String errorMessage = securityService.checkAccessResult(securityContext);

            if (errorMessage != null) {

                // can not show results
                isAccessAllowed = false;
                registerError(request, errorMessage);
            }
        }

        if (isAccessAllowed) {

            // store security context in request
            PollenUIUtils.setUserSecuritycontext(request, securityContext);
        }
        return isAccessAllowed;
    }


}