/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: DeleteUser.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.2/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/admin/DeleteUser.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.admin;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserNotFoundException;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * Delete a selected user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class DeleteUser extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected String userId;

    protected String redirectUrl;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public String execute() throws Exception {

        Preconditions.checkNotNull(userId);

        UserService service = getUserService();

        String result = INPUT;

        try {
            UserAccount user =
                    service.getEntityById(UserAccount.class, userId);

            service.deleteUser(userId);
            addFlashMessage(
                    _("pollen.information.user.deleted", user.getDisplayName()));

            result = SUCCESS;
        } catch (UserNotFoundException e) {
            addFieldError("deleteUser.login",
                          _("pollen.error.user.not.found"));
        }
        return result;
    }
}
