/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.ui.actions.json.AbstractJSONPaginedAction;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;

public class GetCreatedPolls
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, Object>[] polls;

    public Map<String, Object>[] getPolls() {
        return this.polls;
    }

    public Integer getRows() {
        return this.pager.getPageSize();
    }

    public Integer getPage() {
        return this.pager.getPageIndex();
    }

    public Integer getTotal() {
        return this.pager.getPagesNumber();
    }

    public Integer getRecords() {
        return this.pager.getRecords();
    }

    public String execute() throws Exception {
        PollService pollService = this.getPollService();
        List pollList = pollService.getCreatedPolls(this.pager, this.getPollenUserAccount());
        this.polls = new Map[pollList.size()];
        TopiaEntityBinder binder = PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;
        for (Poll poll : pollList) {
            Map map = pollService.pollToMap(poll, (Binder)binder);
            map.put("adminId", poll.getAdminId());
            map.put("functions", Sets.newHashSet((Object[])new String[]{"summary"}));
            this.polls[index++] = map;
        }
        return "success";
    }
}

