/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: DeleteVote.java 3509 2012-06-18 10:01:58Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/DeleteVote.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.common.PollType;

/**
 * To delete a poll vote.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class DeleteVote extends AbstractPollUriIdAction {

    private static final long serialVersionUID = 1L;

    /**
     * Id of the vote to delete.
     *
     * @since 1.3
     */
    protected String voteId;

    /**
     * Reason for deleting this vote (if any).
     *
     * @since 1.4
     */
    protected String reason;

    public void setVoteId(String voteId) {
        this.voteId = voteId;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(getPollId());
        Preconditions.checkNotNull(voteId);

        Poll poll = getPollService().getExistingPollByPollId(getPollId());

        getVoteService().deleteVote(poll, voteId, reason);

        addFlashMessage(_("pollen.information.vote.deleted"));

        if (poll.getPollType() == PollType.FREE &&
            getUriId().isAccountIdNotBlank() &&
            !poll.getCreator().getAccountId().equals(getAccountId())) {

            // remove accountId from url, voter does no longer exists.
            getUriId().setAccountId(null);
        }
        return SUCCESS;
    }
}
