/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: PollenUIUtils.java 3516 2012-06-18 16:19:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/PollenUIUtils.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui;

import org.chorem.pollen.services.impl.SecurityService;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

/**
 * Useful ui methods.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenUIUtils {

    /** Keep the servlet context */
    private static ServletContext servletContext;

    private static final String ACCOUNT_ID_ROLE = "accountIdRole";

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static void setServletContext(ServletContext servletContext) {
        PollenUIUtils.servletContext = servletContext;
    }

    public static void setAccountIdRole(ServletRequest request,
                                        SecurityService.AccountIdRole accountIdRole) {
        request.setAttribute(ACCOUNT_ID_ROLE, accountIdRole);
    }

    public static SecurityService.AccountIdRole getAccountIdRole(ServletRequest request) {
        SecurityService.AccountIdRole result = (SecurityService.AccountIdRole)
                request.getAttribute(ACCOUNT_ID_ROLE);
        return result;
    }

    protected PollenUIUtils() {
        // helper can not be instanciated
    }
}
