/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.inject.Inject;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.pollen.PollenApplicationContext;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.DefaultPollenServiceContext;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenServiceFactory;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.impl.FavoriteService;
import org.chorem.pollen.services.impl.PollCommentService;
import org.chorem.pollen.services.impl.PollFeedService;
import org.chorem.pollen.services.impl.PollResultsService;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.services.impl.PollUrlService;
import org.chorem.pollen.services.impl.PreventRuleService;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.services.impl.VoteService;
import org.chorem.pollen.ui.PollenSession;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;
import org.chorem.pollen.votecounting.strategy.VoteCountingStrategy;
import org.chorem.pollen.votecounting.strategy.VoteCountingStrategyProvider;
import org.nuiton.topia.TopiaContext;
import org.nuiton.web.filter.TopiaTransactionFilter;
import org.nuiton.web.struts2.BaseAction;

/*
 * Exception performing whole class analysis ignored.
 */
public class PollenActionSupport
extends BaseAction
implements ServletRequestAware {
    private static final long serialVersionUID = 1L;
    private transient PollenSession pollenSession;
    @Inject
    protected transient PollenServiceFactory serviceFactory;
    protected transient PollenServiceContext serviceContext;
    protected transient TopiaContext transaction;
    private transient Map<Class<? extends PollenServiceSupport>, PollenServiceSupport> services;
    private transient HttpServletRequest request;
    private Map<String, String[]> parameters;
    private PollenUserSecurityContext securityContext;
    private final PageSkin skin;
    public static final List<String> SAFE_LANGUAGES = Lists.newArrayList((Object[])new String[]{"en", "fr"});

    public static PollenApplicationContext getPollenApplicationContext() {
        PollenApplicationContext applicationContext = PollenApplicationContext.get((ActionContext)ActionContext.getContext());
        return applicationContext;
    }

    public PollenConfiguration getConfiguration() {
        return PollenActionSupport.getPollenApplicationContext().getConfiguration();
    }

    public PollenActionSupport() {
        this(PageSkin.INDEX);
    }

    public PollenActionSupport(PageSkin skin) {
        this.skin = skin;
    }

    public final PageSkin getSkin() {
        return this.skin;
    }

    public final String getPageLogo() {
        return this.getSkin().getCssSuffix();
    }

    public final String getJqueryTheme() {
        return this.getSkin().getTheme();
    }

    public PollenSession getPollenSession() {
        if (this.pollenSession == null) {
            this.pollenSession = PollenSession.get((ActionContext)ActionContext.getContext());
        }
        return this.pollenSession;
    }

    public UserAccount getPollenUserAccount() {
        return this.getPollenSession().getUserAccount();
    }

    public boolean isUserLoggued() {
        UserAccount userAccount = this.getPollenUserAccount();
        return userAccount != null;
    }

    public boolean isUserAdmin() {
        UserAccount userAccount = this.getPollenUserAccount();
        return userAccount != null && userAccount.isAdministrator();
    }

    public static String getApplicationVersion() {
        return PollenActionSupport.getPollenApplicationContext().getConfiguration().getVersion().toString();
    }

    public URL getApplicationUrl() {
        URL url = this.getServiceContext().getApplicationURL();
        return url;
    }

    public final void setServletRequest(HttpServletRequest request) {
        Preconditions.checkNotNull((Object)request);
        this.request = request;
    }

    public final void setParameters(Map<String, String[]> parameters) {
        Preconditions.checkNotNull(parameters);
        this.parameters = Maps.newHashMap(parameters);
    }

    public final void setPollenUserSecurityContext(PollenUserSecurityContext pollenUserSecurityContext) {
        Preconditions.checkNotNull((Object)pollenUserSecurityContext);
        this.securityContext = pollenUserSecurityContext;
    }

    public PollUri getPollUri() {
        PollUri result = this instanceof PollenUserSecurityAware ? this.getUserSecurityContext().getPollUri() : null;
        return result;
    }

    public VoteCountingStrategyProvider getVoteCountingStrategyProvider() {
        return PollenActionSupport.getPollenApplicationContext().getVoteCountingStrategyProvider();
    }

    public TopiaContext getTransaction() {
        if (this.transaction == null) {
            this.transaction = TopiaTransactionFilter.getTransaction((ServletRequest)this.request);
        }
        return this.transaction;
    }

    public String getSafeLanguage() {
        String language = this.getLocale().getLanguage();
        if (!SAFE_LANGUAGES.contains(language)) {
            language = (String)SAFE_LANGUAGES.get(0);
        }
        return language;
    }

    public static Date getCurrentDateTime() {
        return new Date();
    }

    public String getCurrentUrl() {
        String result = this.request.getRequestURL().toString();
        return result;
    }

    public void addFlashMessage(String message) {
        this.getPollenSession().addMessage("messages", message);
    }

    public void addFlashError(String message) {
        this.getPollenSession().addMessage("errors", message);
    }

    public void addFlashWarning(String message) {
        this.getPollenSession().addMessage("warnings", message);
    }

    public Collection<String> getFlashMessages() {
        Set result = this.getPollenSession().consumeDynamicSetData("messages");
        return result;
    }

    public Collection<String> getFlashErrors() {
        Set result = this.getPollenSession().consumeDynamicSetData("errors");
        return result;
    }

    public Collection<String> getFlashWarnings() {
        Set result = this.getPollenSession().consumeDynamicSetData("warnings");
        return result;
    }

    public boolean hasFlashMessages() {
        Set result = this.getPollenSession().getDynamicSetData("messages");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public boolean hasFlashErrors() {
        Set result = this.getPollenSession().getDynamicSetData("errors");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public boolean hasFlashWarnings() {
        Set result = this.getPollenSession().getDynamicSetData("warnings");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public void clearFlashMessages() {
        Set result = this.getPollenSession().getDynamicSetData("messages");
        if (result != null) {
            result.clear();
        }
    }

    public void clearFlashErrors() {
        Set result = this.getPollenSession().getDynamicSetData("errors");
        if (result != null) {
            result.clear();
        }
    }

    public boolean hasAnyErrors() {
        boolean result = super.hasErrors();
        return result || this.hasFlashErrors();
    }

    protected final PollService getPollService() {
        return (PollService)this.getService(PollService.class);
    }

    protected final PollUrlService getPollUrlService() {
        return (PollUrlService)this.getService(PollUrlService.class);
    }

    protected final PollResultsService getPollResultsService() {
        return (PollResultsService)this.getService(PollResultsService.class);
    }

    protected final VoteService getVoteService() {
        return (VoteService)this.getService(VoteService.class);
    }

    protected final PollCommentService getPollCommentService() {
        return (PollCommentService)this.getService(PollCommentService.class);
    }

    protected final PollFeedService getPollFeedService() {
        return (PollFeedService)this.getService(PollFeedService.class);
    }

    protected final UserService getUserService() {
        return (UserService)this.getService(UserService.class);
    }

    protected final FavoriteService getFavoriteService() {
        return (FavoriteService)this.getService(FavoriteService.class);
    }

    protected final PreventRuleService getPreventRuleService() {
        return (PreventRuleService)this.getService(PreventRuleService.class);
    }

    protected final SecurityService getSecurityService() {
        return (SecurityService)this.getService(SecurityService.class);
    }

    protected final <S extends PollenServiceSupport> S getService(Class<S> serviceType) {
        PollenServiceSupport result;
        if (this.services == null) {
            this.services = Maps.newHashMap();
        }
        if ((result = (PollenServiceSupport)this.services.get(serviceType)) == null) {
            result = (PollenServiceSupport)this.serviceFactory.newService(serviceType, this.getServiceContext());
            this.services.put(serviceType, result);
        }
        return (S)result;
    }

    protected boolean isGetMethod() {
        Preconditions.checkNotNull((Object)this.request);
        return "GET".equalsIgnoreCase(this.request.getMethod());
    }

    protected final PollenUserSecurityContext getUserSecurityContext() {
        Preconditions.checkNotNull((Object)this.securityContext, (Object)"To use the pollenUserSecurityContext, make your action implements PollenUserSecurityAware.");
        return this.securityContext;
    }

    protected final Map<String, String[]> getParameters() {
        Preconditions.checkNotNull((Object)this.parameters);
        return this.parameters;
    }

    protected VoteCountingStrategy getVoteCountingStrategy(Poll poll) {
        int voteCountingType = poll.getVoteCountingType();
        VoteCountingStrategy result = this.getVoteCountingStrategyProvider().getStrategy(voteCountingType);
        return result;
    }

    protected PollenServiceContext getServiceContext() {
        if (this.serviceContext == null) {
            this.serviceContext = DefaultPollenServiceContext.newContext((Locale)this.getLocale(), (TopiaContext)this.getTransaction(), (PollenConfiguration)this.getConfiguration(), (PollenServiceFactory)this.serviceFactory, (VoteCountingStrategyProvider)this.getVoteCountingStrategyProvider());
        }
        return this.serviceContext;
    }
}

