/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: BooleanIntegerConverter.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/converters/BooleanIntegerConverter.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.converters;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.util.StrutsTypeConverter;

import java.util.Map;

/**
 * Created: 26/03/12
 *
 * @author fdesbois <desbois@codelutin.com>
 */
public class BooleanIntegerConverter extends StrutsTypeConverter {

    @Override
    public Integer convertFromString(Map context, String[] values, Class toClass) {
        Integer result;
        if (values.length == 1) {
            result = parseValue(values[0]);

        } else {
            result = null;
        }
        return result;
    }

    protected Integer parseValue(String value) {
        Integer result;
        if (StringUtils.isEmpty(value)) {
            result = null;
        } else if ("true".equals(value)) {
            result = 1;

        } else if ("false".equals(value)) {
            result = 0;

        } else {
            result = Integer.parseInt(value);
        }
        return result;
    }

    @Override
    public String convertToString(Map context, Object object) {
        return object == null ? "" : String.valueOf(object);
    }
}
