/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserLoginAlreadyUsedException;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class Register
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected UserAccount user;
    protected String password2;

    public UserAccount getUser() {
        if (this.user == null) {
            UserService service = (UserService)this.newService(UserService.class);
            this.user = service.getNewUser();
        }
        return this.user;
    }

    public String getPassword2() {
        return this.password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public String execute() throws Exception {
        String result = "input";
        try {
            UserAccount createdUser = ((UserService)this.newService(UserService.class)).createUser(this.user, false);
            this.getPollenSession().setUserAccount(createdUser);
            this.addFlashMessage(this._("pollen.information.your.are.loggued", new Object[0]));
            result = "success";
        }
        catch (UserLoginAlreadyUsedException e) {
            this.addFieldError("user.login", this._("pollen.error.user.login.already.used", new Object[0]));
        }
        catch (UserEmailAlreadyUsedException e) {
            this.addFieldError("user.email", this._("pollen.error.user.email.already.used", new Object[0]));
        }
        this.user.setPassword(null);
        this.password2 = null;
        return result;
    }
}

