/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ParameterAware;
import org.chorem.pollen.bean.PollResult;
import org.chorem.pollen.bean.PollResultList;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.services.exceptions.PollAccountNotFound;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.services.impl.PollCommentService;
import org.chorem.pollen.services.impl.PollFeedService;
import org.chorem.pollen.services.impl.PollResultsService;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.services.impl.VoteService;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.poll.AbstractPollUriIdAction;
import org.chorem.pollen.ui.actions.poll.AbstractVoteAction;

public abstract class AbstractVoteAction
extends AbstractPollUriIdAction
implements ParameterAware {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractVoteAction.class);
    private transient PollResultsService pollResultsService;
    private transient PollService pollService;
    private transient VoteService voteService;
    private transient PollCommentService pollCommentService;
    private Poll poll;
    private boolean feedFileExisting;
    private boolean creatorUser;
    private PollAccount pollAccount;
    private boolean alreadyVoted;
    private boolean voteAllowed;
    private List<Vote> votes;
    private Vote vote;
    private String commentAuthor;
    private List<PollResult> results;
    private List<Comment> comments;
    private Map<String, String[]> parameters;

    public PageSkin getSkin() {
        return PageSkin.VOTE;
    }

    protected PollResultsService getPollResultsService() {
        if (this.pollResultsService == null) {
            this.pollResultsService = (PollResultsService)this.newService(PollResultsService.class);
        }
        return this.pollResultsService;
    }

    protected PollService getPollService() {
        if (this.pollService == null) {
            this.pollService = (PollService)this.newService(PollService.class);
        }
        return this.pollService;
    }

    protected VoteService getVoteService() {
        if (this.voteService == null) {
            this.voteService = (VoteService)this.newService(VoteService.class);
        }
        return this.voteService;
    }

    protected PollCommentService getPollCommentService() {
        if (this.pollCommentService == null) {
            this.pollCommentService = (PollCommentService)this.newService(PollCommentService.class);
        }
        return this.pollCommentService;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public boolean isFeedFileExisting() {
        return this.feedFileExisting;
    }

    public PollAccount getPollAccount() {
        return this.pollAccount;
    }

    public List<Vote> getVotes() {
        return this.votes;
    }

    public Vote getVote() {
        return this.vote;
    }

    public boolean isPollChoiceOrVoteStarted() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.isAddChoiceStarted(now) || this.poll.isStarted(now);
    }

    public boolean isAlreadyVoted() {
        return this.alreadyVoted;
    }

    public boolean isAnonymousVote() {
        return this.poll.isAnonymous();
    }

    public List<PollResult> getResults() {
        return this.results;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public boolean isCreatorUser() {
        return this.creatorUser;
    }

    public boolean isAccountFieldDisplayed() {
        return !this.poll.isAnonymous() || this.isRestrictedPoll() || this.isGroupPoll();
    }

    public boolean isPollChoiceRunning() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.isAddChoiceRunning(now);
    }

    public String getCreatorName() {
        return this.poll.getCreator().getVotingId();
    }

    public String getVoteSizeMessage() {
        return this._("pollen.common.voteNbVotes", new Object[]{this.getPoll().sizeVote()});
    }

    public boolean isDescNull(Choice choice) {
        return StringUtils.isEmpty((CharSequence)choice.getDescription());
    }

    public boolean isFreePoll() {
        return this.poll.getPollType() == PollType.FREE;
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public boolean isTextType() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateType() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImageType() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    public boolean isNormalVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.NORMAL;
    }

    public boolean isPercentageVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.PERCENTAGE;
    }

    public boolean isCondorcetVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.CONDORCET;
    }

    public boolean isNumberVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.NUMBER;
    }

    public boolean isPollStarted() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.getBeginDate() == null || this.poll.getBeginDate().before(now);
    }

    public boolean isPollFinished() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.getEndDate() != null && this.poll.getEndDate().before(now);
    }

    public String getCommentAuthor() {
        if (this.commentAuthor == null) {
            UserAccount user = this.getPollenUserAccount();
            this.commentAuthor = user == null ? this.getPollAccount().getVotingId() : user.getDisplayName();
        }
        return this.commentAuthor;
    }

    public void setCommentAuthor(String commentAuthor) {
        this.commentAuthor = commentAuthor;
    }

    public String prepareVotePage() throws Exception {
        this.loadPoll();
        this.loadPollAccount();
        this.votes = this.poll.getVote();
        this.voteAllowed = this.getVoteService().isVoteAllowed(this.poll, this.pollAccount);
        if (this.voteAllowed) {
            this.vote = this.getVoteService().getVoteEditable(this.poll, this.pollAccount);
        }
        this.loadPollResults();
        this.loadPollComments();
        PollFeedService pollFeedService = (PollFeedService)this.newService(PollFeedService.class);
        this.feedFileExisting = pollFeedService.isFeedExists(this.poll);
        PollAccount pollCreator = this.poll.getCreator();
        this.creatorUser = this.getPollenUserAccount() == null ? pollCreator.equals(this.pollAccount) : this.getPollenUserAccount().equals(pollCreator.getUserAccount());
        if (this.poll.isClosed()) {
            this.addFlashMessage(this._("pollen.information.pollClosed", new Object[0]));
        } else if (!this.isPollStarted()) {
            this.addFlashMessage(this._("pollen.information.pollNotStarted", new Object[0]));
        } else if (this.isPollFinished()) {
            this.addFlashMessage(this._("pollen.information.pollFinished", new Object[0]));
        } else if (pollCreator.equals(this.pollAccount)) {
            this.addFlashWarning(this._("pollen.information.vote.creatorUser", new Object[0]));
        }
        if (this.isPollChoiceRunning()) {
            this.addFlashMessage(this._("pollen.information.pollChoiceRunning", new Object[0]));
        }
        if (log.isInfoEnabled()) {
            Date now = this.serviceContext.getCurrentTime();
            log.info((Object)("pollChoiceOrVoteStarted = " + this.isPollChoiceOrVoteStarted()));
            log.info((Object)("pollChoiceRunning       = " + this.isPollChoiceRunning()));
            log.info((Object)("pollRunning             = " + this.poll.isRunning(now)));
            log.info((Object)("accountFieldDisplayed   = " + this.isAccountFieldDisplayed()));
            log.info((Object)("creatorUser             = " + this.creatorUser));
        }
        return "input";
    }

    public String getResultValue(Choice choice) {
        String val = this.getPollResultsService().getResultValue(choice, (Collection)this.results);
        return val;
    }

    public boolean isChoiceInVote(VoteToChoice choice) {
        boolean result = false;
        if (choice != null) {
            switch (1.$SwitchMap$org$chorem$pollen$common$VoteCountingType[this.poll.getVoteCountingType().ordinal()]) {
                case 1: {
                    result = choice.getVoteValue() > 0;
                    break;
                }
                case 2: {
                    result = true;
                    break;
                }
                case 3: {
                    result = choice.getVoteValue() < 100;
                    break;
                }
                case 4: {
                    result = choice.getVoteValue() >= 0;
                }
            }
        }
        return result;
    }

    public boolean isModifAllowed(Vote vote) {
        return this.getVoteService().isUpdateAllowed(this.getPoll(), vote.getTopiaId(), this.getAccountId(), this.getPollenUserAccount());
    }

    public boolean isVoteAllowed() {
        return this.voteAllowed;
    }

    public boolean isDeleteCommentAllowed(Comment comment) {
        return this.getPollCommentService().isCanDeleteComment(comment, this.getPollAccount(), this.getPollenUserAccount());
    }

    public boolean isDeleteVoteAllowed(Vote vote) {
        return this.isUserAdmin();
    }

    public String escapeLineBreak(String text) {
        return text;
    }

    public Date getChoiceAsDate(Choice choice) {
        return new Date(Long.valueOf(choice.getName()));
    }

    protected void loadPollAccount() throws PollAccountNotFound {
        this.pollAccount = this.getPollService().getPollAccountEditable(this.getAccountId(), this.getPollenUserAccount(), this.poll);
    }

    protected void loadPoll() throws PollNotFoundException {
        this.preparePollUri(this.parameters);
        String pollId = this.getPollId();
        if (StringUtils.isNotEmpty((CharSequence)pollId)) {
            this.poll = this.getPollService().getPollByPollId(pollId);
        }
        Preconditions.checkNotNull((Object)this.poll, (Object)("Can't load poll with id = [" + pollId + "]"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Poll TopiaId: " + this.poll.getTopiaId()));
        }
    }

    protected void loadPollComments() {
        PollCommentService service = (PollCommentService)this.newService(PollCommentService.class);
        this.comments = service.getAllComments(this.poll.getPollId());
    }

    protected void loadPollResults() throws PollNotFoundException {
        PollResultsService service = this.getPollResultsService();
        PollResultList pollResultList = service.getResults(this.poll.getPollId());
        this.results = pollResultList.getPollResults();
        if (log.isDebugEnabled()) {
            for (PollResult res : this.results) {
                log.debug((Object)(res.getName() + ": " + res.getValue() + ", (voteCounting=" + res.getVoteCountingType() + ", byGroup=" + res.isByGroup() + ")"));
            }
        }
    }
}

