/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.ui.actions.json.AbstractJSONPaginedAction;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;

public class GetParticipatedPolls
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, Object>[] polls;

    public Map<String, Object>[] getPolls() {
        return this.polls;
    }

    public Integer getRows() {
        return this.pager.getPageSize();
    }

    public Integer getPage() {
        return this.pager.getPageIndex();
    }

    public Integer getTotal() {
        return this.pager.getPagesNumber();
    }

    public Integer getRecords() {
        return this.pager.getRecords();
    }

    public String execute() throws Exception {
        PollService pollService = (PollService)this.newService(PollService.class);
        List participatedPolls = pollService.getParticipatedPolls(this.pager, this.getPollenUserAccount());
        this.polls = new Map[participatedPolls.size()];
        TopiaEntityBinder binder = PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;
        for (Pair entry : participatedPolls) {
            Poll poll = (Poll)entry.getKey();
            Map map = pollService.pollToMap(poll, (Binder)binder);
            PollAccount account = (PollAccount)entry.getValue();
            PollUri pollUri = PollUri.newPollUri((String)poll.getPollId(), (String)account.getAccountId());
            map.put("voteId", pollUri.getUri());
            String resultId = poll.getPollType() == PollType.FREE ? pollUri.getPollId() : pollUri.getUri();
            map.put("resultId", resultId);
            Set functions = this.getPollFunctions(poll);
            map.put("functions", functions);
            this.polls[index++] = map;
        }
        return "success";
    }

    private Set<String> getPollFunctions(Poll poll) {
        HashSet result = Sets.newHashSet();
        result.add("vote");
        if (poll.isPublicResults()) {
            result.add("result");
        }
        return result;
    }
}

