/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: PollCreatorRequired.java 3394 2012-05-28 15:27:04Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/security/PollCreatorRequired.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.services.exceptions.UnauthorizedPollAccessException;
import org.chorem.pollen.services.impl.PollService;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class PollCreatorRequired extends AbstractPollenAuthorization {

    private static final Log log = LogFactory.getLog(PollCreatorRequired.class);

    protected final AdminUserRequired adminFilter;

    public PollCreatorRequired() {
        adminFilter = new AdminUserRequired();
    }


    @Override
    protected boolean isAccessAllowed(ServletRequest request,
                                      ServletResponse response,
                                      Object mappedValue) {

        boolean isAccessAllowed;

        if (adminFilter.isAccessAllowed(request, response, mappedValue)) {

            // user is connected ans admin, so
            isAccessAllowed = true;

        } else {

            PollUri pollUri = getPollUri(request);

            if (pollUri == null) {

                // no uriId given
                isAccessAllowed = false;


            } else {
                PollenServiceContext serviceContext =
                        getServiceContext(request);

                PollService pollService =
                        serviceContext.newService(PollService.class);

                try {
                    pollService.checkPollCreator(pollUri);
                    isAccessAllowed = true;

                    if (log.isDebugEnabled()) {
                        log.debug("Can access to this poll " +
                                  pollUri.getPollId());
                    }
                } catch (PollNotFoundException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Poll not found!");
                    }
                    isAccessAllowed = false;
                } catch (UnauthorizedPollAccessException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("User can not access page");
                    }
                    isAccessAllowed = false;
                }

            }
        }

        return isAccessAllowed;
    }

}
