/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.security;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.DefaultPollenServiceContext;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenServiceFactory;
import org.chorem.pollen.ui.PollenApplicationContext;
import org.chorem.pollen.ui.PollenSession;
import org.chorem.pollen.ui.PollenUIUtils;
import org.nuiton.topia.TopiaContext;
import org.nuiton.web.filter.TopiaTransactionFilter;

public abstract class AbstractPollenAuthorization
extends AuthorizationFilter {
    public static final Pattern URI_PATTERN = Pattern.compile("/(.[^/]+)/(.[^/]+)/(.[^!/]+)(/.[^!/]*){0,1}(!.*){0,1}");
    private static final Log log = LogFactory.getLog(AbstractPollenAuthorization.class);

    protected AbstractPollenAuthorization() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Init - " + this));
        }
    }

    public ServletContext getServletContext() {
        ServletContext servletContext = super.getServletContext();
        if (servletContext == null) {
            servletContext = PollenUIUtils.getServletContext();
            Preconditions.checkNotNull((Object)servletContext);
            this.setServletContext(servletContext);
        }
        return servletContext;
    }

    protected PollUri getPollUri(ServletRequest request) {
        String servletPath = ((HttpServletRequest)request).getServletPath();
        Matcher m = URI_PATTERN.matcher(servletPath);
        PollUri result = null;
        if (m.find()) {
            String uriId = m.group(3);
            result = PollUri.newPollUri((String)uriId);
        }
        return result;
    }

    protected UserAccount getPollenUSerAccount(ServletRequest request) {
        PollenSession pollenSession = PollenSession.get((ServletRequest)request);
        return pollenSession.getUserAccount();
    }

    protected PollenServiceContext getServiceContext(ServletRequest request) {
        PollenApplicationContext applicationContext = PollenApplicationContext.get((ServletContext)this.getServletContext());
        PollenServiceFactory serviceFactory = new PollenServiceFactory();
        TopiaContext transaction = TopiaTransactionFilter.getTransaction((ServletRequest)request);
        Locale locale = Locale.getDefault();
        return DefaultPollenServiceContext.newContext((Locale)locale, (TopiaContext)transaction, (PollenConfiguration)applicationContext.getConfiguration(), (PollenServiceFactory)serviceFactory);
    }

    protected final boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        String unauthorizedUrl = this.getUnauthorizedUrl();
        if (StringUtils.hasText((String)unauthorizedUrl)) {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)unauthorizedUrl);
        } else {
            WebUtils.toHttp((ServletResponse)response).sendError(401);
        }
        return false;
    }
}

