/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class Edit
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected UserAccount user;
    protected String newPassword;
    protected String newPassword2;

    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public UserAccount getUser() {
        if (this.user == null) {
            UserService service = (UserService)this.newService(UserService.class);
            this.user = service.getNewUser();
        }
        return this.user;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPassword2() {
        return this.newPassword2;
    }

    public void setNewPassword2(String newPassword2) {
        this.newPassword2 = newPassword2;
    }

    public String input() throws Exception {
        UserAccount userAccount = this.getPollenUserAccount();
        UserService userService = (UserService)this.newService(UserService.class);
        this.user = (UserAccount)userService.getEntityById(UserAccount.class, userAccount.getTopiaId());
        return "input";
    }

    public String execute() throws Exception {
        this.user.setAdministrator(this.getPollenUserAccount().isAdministrator());
        UserService service = (UserService)this.newService(UserService.class);
        String result = "input";
        try {
            UserAccount updatedUser = service.updateUser(this.user, this.newPassword, false);
            this.getTransaction().commitTransaction();
            this.getPollenSession().setUserAccount(updatedUser);
            result = "success";
        }
        catch (UserEmailAlreadyUsedException e) {
            this.addFieldError("user.email", this._("pollen.error.user.email.already.used", new Object[0]));
        }
        catch (UserInvalidPasswordException e) {
            this.addFieldError("user.password", this._("pollen.error.user.invalid.password", new Object[0]));
        }
        this.user.setPassword(null);
        this.newPassword2 = null;
        this.newPassword = null;
        return result;
    }
}

