/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import java.util.Collection;
import java.util.List;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.ui.actions.poll.AbstractPollForm;

public class LoadPoll
extends AbstractPollForm {
    private static final long serialVersionUID = 1L;
    private PollUri pollUri;
    private boolean clone;

    public PollUri getUriId() {
        return this.pollUri;
    }

    public void setUriId(PollUri pollUri) {
        this.pollUri = pollUri;
    }

    public void setClone(boolean clone) {
        this.clone = clone;
    }

    public String execute() throws Exception {
        PreventRule notification;
        PreventRule reminder;
        this.prepareFormPage();
        UserAccount userAccount = this.getPollenUserAccount();
        String pollUid = this.pollUri == null ? null : this.pollUri.getPollId();
        this.poll = this.getPollService().getPollEditable(pollUid, userAccount, this.clone);
        if (this.poll.isClosed()) {
            this.addFlashWarning(this._("pollen.warning.poll.is.closed.so.read.only", new Object[0]));
        }
        List pollChoices = this.poll.getChoice();
        List pollVotingLists = this.poll.getVotingList();
        this.loadChoicesAndvotingLists(this.poll, (Collection)pollChoices, (Collection)pollVotingLists, !this.isVoteStarted());
        if (this.poll.getMaxChoiceNb() > 0) {
            this.setLimitChoice(true);
        }
        if ((reminder = this.poll.getPreventRuleByScope("rappel")) != null) {
            this.setReminder(true);
            this.setReminderHourCountdown(reminder.getSensibility());
        }
        if ((notification = this.poll.getPreventRuleByScope("vote")) != null) {
            this.setNotification(true);
        }
        if (this.isVoteStarted()) {
            this.addFlashMessage(this._("pollen.information.poll.form.voteStarted", new Object[0]));
        }
        return "success";
    }
}

