/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.collect.Iterables;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.bean.ChoiceHelper;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.ui.actions.FileUploadAware;
import org.chorem.pollen.ui.actions.poll.AbstractVoteAction;

public class AddChoice
extends AbstractVoteAction
implements Preparable,
FileUploadAware {
    private static final long serialVersionUID = 1L;
    protected Choice choice;
    private File imageChoice;
    private String imageChoiceContentType;
    private String imageChoiceFileName;

    public Choice getChoice() {
        return this.choice;
    }

    public void addFile(int index, File file) {
        this.imageChoice = file;
    }

    public void addFileContentType(int index, String contentType) {
        this.imageChoiceContentType = contentType;
    }

    public void addFileName(int index, String fileName) {
        this.imageChoiceFileName = fileName;
    }

    public void prepare() throws PollNotFoundException {
        this.loadPoll();
        ChoiceType choiceType = this.getPoll().getChoiceType();
        this.choice = this.getPollService().getNewChoice(choiceType);
        if (ChoiceType.IMAGE == choiceType && this.imageChoice != null) {
            String fileName = this.imageChoiceFileName;
            String location = this.imageChoice.getAbsolutePath();
            this.choice.setName(fileName);
            ((PollImageChoice)this.choice).setLocation(location);
        }
    }

    public void validate() {
        ChoiceType choiceType = this.getPoll().getChoiceType();
        String propName = ChoiceHelper.getValuePropertyName((ChoiceType)choiceType);
        Object value = ChoiceHelper.toValue((Choice)this.choice, (ChoiceType)choiceType);
        if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
            String typeLabel = this.getText(choiceType.getI18nKey());
            this.addFieldError("choice." + propName, this._("pollen.error.choice.empty", new Object[]{typeLabel}));
        } else {
            Iterable pollChoiceValues = ChoiceHelper.toValues((Iterable)this.getPoll().getChoice(), (ChoiceType)choiceType);
            if (Iterables.contains((Iterable)pollChoiceValues, (Object)value)) {
                this.addFieldError("choice." + propName, this._("pollen.error.poll.detected.duplicate.choice.name", new Object[0]));
            }
        }
    }

    @InputConfig(methodName="prepareVotePage")
    public String execute() throws Exception {
        this.getPollService().addChoice(this.getPollId(), this.choice);
        return "success";
    }
}

