/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.admin;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserNotFoundException;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class DeleteUser
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected String redirectUrl;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String execute() throws Exception {
        Preconditions.checkNotNull((Object)this.userId);
        UserService service = (UserService)this.newService(UserService.class);
        String result = "input";
        try {
            UserAccount user = (UserAccount)service.getEntityById(UserAccount.class, this.userId);
            service.deleteUser(this.userId);
            this.getTransaction().commitTransaction();
            this.addFlashMessage(this._("pollen.information.user.deleted", new Object[]{user.getDisplayName()}));
            result = "success";
        }
        catch (UserNotFoundException e) {
            this.addFieldError("deleteUser.login", this._("pollen.error.user.not.found", new Object[0]));
        }
        return result;
    }
}

