/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: Register.java 3333 2012-04-30 15:52:41Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/Register.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.user;

import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserLoginAlreadyUsedException;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * Register a new user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class Register extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected UserAccount user;

    protected String password2;

    public UserAccount getUser() {
        if (user == null) {
            UserService service = newService(UserService.class);
            user = service.getNewUser();
        }
        return user;
    }

    public String getPassword2() {
        return password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    @Override
    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    @Override
    public String execute() throws Exception {

        String result = INPUT;
        try {
            UserAccount createdUser =
                    newService(UserService.class).createUser(user, false);

            getPollenSession().setUserAccount(createdUser);
            addFlashMessage(_("pollen.information.your.are.loggued"));
            result = SUCCESS;
        } catch (UserLoginAlreadyUsedException e) {
            addFieldError("user.login", _("pollen.error.user.login.already.used"));
        } catch (UserEmailAlreadyUsedException e) {
            addFieldError("user.email", _("pollen.error.user.email.already.used"));
        }

        // if error go back to input

        // reset password
        user.setPassword(null);
        password2 = null;

        return result;
    }
}
