/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: Edit.java 3260 2012-04-13 15:41:50Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/Edit.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.user;

import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * Update a user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class Edit extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected UserAccount user;

    protected String newPassword;

    protected String newPassword2;

    @Override
    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public UserAccount getUser() {
        if (user == null) {
            UserService service = newService(UserService.class);
            user = service.getNewUser();
        }
        return user;
    }

    public String getNewPassword() {
        return newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPassword2() {
        return newPassword2;
    }

    public void setNewPassword2(String newPassword2) {
        this.newPassword2 = newPassword2;
    }

    public String input() throws Exception {
        UserAccount userAccount = getPollenUserAccount();
        UserService userService = newService(UserService.class);
        user = userService.getEntityById(UserAccount.class, userAccount.getTopiaId());
        return INPUT;
    }

    @Override
    public String execute() throws Exception {

        // let's push back admin property to user to save
        user.setAdministrator(
                getPollenUserAccount().isAdministrator());

        UserService service = newService(UserService.class);

        String result = INPUT;
        try {
            UserAccount updatedUser =
                    service.updateUser(user, newPassword, false);
            getTransaction().commitTransaction();

            // push back user to session
            getPollenSession().setUserAccount(updatedUser);
            result = SUCCESS;
        } catch (UserEmailAlreadyUsedException e) {
            addFieldError("user.email", _("pollen.error.user.email.already.used"));
        } catch (UserInvalidPasswordException e) {
            addFieldError("user.password", _("pollen.error.user.invalid.password"));
        }

        // reset password
        user.setPassword(null);
        newPassword = newPassword2 = null;

        return result;
    }

}
