/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: AbstractDisplayChoice.java 3394 2012-05-28 15:27:04Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/AbstractDisplayChoice.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.ui.actions.PollenActionSupport;

import java.util.Map;

/**
 * To generate the display for a text choice.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public abstract class AbstractDisplayChoice extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    /** Where to find dynamic data (says choices in this case). */
    protected String tokenId;

    /** Number of choice to display. */
    protected int choiceNumber;

    /**
     * Choice to display in ui (come from dynamic data if exists, or fresh
     * created one).
     */
    protected Choice choice;

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public void setChoiceNumber(int choiceNumber) {
        this.choiceNumber = choiceNumber;
    }

    public Choice getChoice() {
        return choice;
    }

    public int getChoiceNumber() {
        return choiceNumber;
    }

    protected abstract Choice createEmptyChoice();

    @Override
    public String execute() throws Exception {
        if (StringUtils.isNotEmpty(tokenId)) {

            Map<Integer, Choice> choices =
                    getPollenSession().getDynamicData(tokenId);

            if (choices != null) {

                // get choices from datas
                choice = choices.get(choiceNumber);

                if (choice != null) {

                    // remove this choice from session
                    choices.remove(choiceNumber);
                }
            }

            if (MapUtils.isEmpty(choices)) {

                // remove it from session
                getPollenSession().removeDynamicData(tokenId);
            }
        }

        if (choice == null) {
            choice = createEmptyChoice();
        }
        return SUCCESS;
    }

}
