/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: ManageUsers.java 3333 2012-04-30 15:52:41Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/admin/ManageUsers.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.admin;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.services.exceptions.UserLoginAlreadyUsedException;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ManageUsers extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected String action;

    protected UserAccount user;

    public UserAccount getUser() {
        if (user == null) {
            UserService service = newService(UserService.class);
            user = service.getNewUser();
        }
        return user;
    }

    public UserAccount getCreateUser() {
        return getUser();
    }

    public UserAccount getEditUser() {
        return getUser();
    }

//    public UserAccount getDeleteUser() {
//        return getUser();
//    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String create() throws Exception {

        Preconditions.checkNotNull(user);

        String result = INPUT;
        try {
            newService(UserService.class).createUser(user, true);

            addFlashMessage(
                    _("pollen.information.user.created",
                      user.getDisplayName()));
            // remove this user, otherwise it will be reused in the user lists
            user = null;
            action = null;
            result = SUCCESS;
        } catch (UserLoginAlreadyUsedException e) {
            addFieldError("createUser.login",
                          _("pollen.error.user.login.already.used"));

        } catch (UserEmailAlreadyUsedException e) {
            addFieldError("createUser.email",
                          _("pollen.error.user.email.already.used"));
        }

        return result;
    }

    public String edit() throws Exception {

        Preconditions.checkNotNull(user);

        UserService service = newService(UserService.class);

        String result = INPUT;

        try {
            service.updateUser(user, null, true);
            getTransaction().commitTransaction();
            addFlashMessage(
                    _("pollen.information.user.updated",
                      user.getDisplayName()));

            // remove this user, otherwise it will be reused in the user lists
            user = null;
            action = null;
            result = SUCCESS;
        } catch (UserEmailAlreadyUsedException e) {
            addFieldError("editUser.email",
                          _("pollen.error.user.email.already.used"));
        } catch (UserInvalidPasswordException e) {
            addFieldError("editUser.password",
                          _("pollen.error.user.invalid.password"));
        }

        return result;
    }

//    public String delete() throws Exception {
//
//        Preconditions.checkNotNull(user);
//
//        UserService service = newService(UserService.class);
//
//        String result = INPUT;
//
//        try {
//            service.deleteUser(user.getTopiaId());
//            getTransaction().commitTransaction();
//            addFlashMessage(
//                    _("pollen.information.user.deleted", user.getDisplayName()));
//
//            // remove this user, otherwise it will be reused in the user lists
//            user = null;
//            action = null;
//            result = SUCCESS;
//        } catch (UserNotFoundException e) {
//            addFieldError("deleteUser.login",
//                          _("pollen.error.user.not.found"));
//        }
//        return result;
//    }
}
