/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.mail;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheFactory;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.SendFailedException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail2.core.EmailException;
import org.apache.commons.mail2.jakarta.Email;
import org.apache.commons.mail2.jakarta.MultiPartEmail;
import org.apache.commons.mail2.jakarta.SimpleEmail;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.ChoiceType;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.EmailToResend;
import org.chorem.pollen.persistence.entity.EmailToResendDao;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.Report;
import org.chorem.pollen.persistence.entity.UserCredential;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.bean.FeedbackBean;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.bean.PollenUserBean;
import org.chorem.pollen.services.config.PollenServicesConfig;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.mail.ChoiceAddedEmail;
import org.chorem.pollen.services.service.mail.ChoiceDeletedEmail;
import org.chorem.pollen.services.service.mail.ChoiceEditedEmail;
import org.chorem.pollen.services.service.mail.ChoiceReportEmail;
import org.chorem.pollen.services.service.mail.ChoiceReportForAdminEmail;
import org.chorem.pollen.services.service.mail.CommentAddedEmail;
import org.chorem.pollen.services.service.mail.CommentDeletedEmail;
import org.chorem.pollen.services.service.mail.CommentEditedEmail;
import org.chorem.pollen.services.service.mail.CommentReportEmail;
import org.chorem.pollen.services.service.mail.CommentReportForAdminEmail;
import org.chorem.pollen.services.service.mail.ExceedingMaxVotersEmail;
import org.chorem.pollen.services.service.mail.FeedbackEmail;
import org.chorem.pollen.services.service.mail.LostPasswordEmail;
import org.chorem.pollen.services.service.mail.PollChoicePeriodEndedEmail;
import org.chorem.pollen.services.service.mail.PollChoicePeriodStartedEmail;
import org.chorem.pollen.services.service.mail.PollClosedEmail;
import org.chorem.pollen.services.service.mail.PollCreatedEmail;
import org.chorem.pollen.services.service.mail.PollEndReminderEmail;
import org.chorem.pollen.services.service.mail.PollInvitationEmail;
import org.chorem.pollen.services.service.mail.PollReportEmail;
import org.chorem.pollen.services.service.mail.PollReportForAdminEmail;
import org.chorem.pollen.services.service.mail.PollVotePeriodEndedEmail;
import org.chorem.pollen.services.service.mail.PollVotePeriodStartedEmail;
import org.chorem.pollen.services.service.mail.PollVoteReminderEmail;
import org.chorem.pollen.services.service.mail.PollenEmailKeyType;
import org.chorem.pollen.services.service.mail.PollenMail;
import org.chorem.pollen.services.service.mail.PollenMailType;
import org.chorem.pollen.services.service.mail.ResendValidationEmail;
import org.chorem.pollen.services.service.mail.RestrictedPollInvitationEmail;
import org.chorem.pollen.services.service.mail.UserAccountCreatedEmail;
import org.chorem.pollen.services.service.mail.UserAccountCreatedFromProviderEmail;
import org.chorem.pollen.services.service.mail.UserAccountDeletedEmail;
import org.chorem.pollen.services.service.mail.UserAccountEditedEmail;
import org.chorem.pollen.services.service.mail.UserAccountEmailAddressAddedEmail;
import org.chorem.pollen.services.service.mail.UserAccountEmailValidatedEmail;
import org.chorem.pollen.services.service.mail.UserAccountPasswordChangedEmail;
import org.chorem.pollen.services.service.mail.VoteAddedEmail;
import org.chorem.pollen.services.service.mail.VoteDeletedEmail;
import org.chorem.pollen.services.service.mail.VoteEditedEmail;
import org.nuiton.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailService
extends PollenServiceSupport {
    private static final Logger log = LoggerFactory.getLogger(EmailService.class);
    public static final String RECIPIENT_SEPARATOR = ";";
    public static final String MAIL_ID_SEPARATOR = "+";
    public static final String MAIL_ID_SEPARATOR_REGEXP = "\\+";

    protected TimeZone getTimeZone() {
        return this.getPollenServiceConfig().getDefaultTimeZone();
    }

    public ChoiceAddedEmail newChoiceAddedEmail(Question question, Choice choice) {
        ChoiceAddedEmail email = new ChoiceAddedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(question.getPoll());
        email.setChoice(choice);
        return email;
    }

    public ChoiceEditedEmail newChoiceEditedEmail(Question question, Choice choice) {
        ChoiceEditedEmail email = new ChoiceEditedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(question.getPoll());
        email.setChoice(choice);
        return email;
    }

    public ChoiceDeletedEmail newChoiceDeletedEmail(Question question, Choice choice) {
        ChoiceDeletedEmail email = new ChoiceDeletedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(question.getPoll());
        email.setChoice(choice);
        return email;
    }

    public CommentAddedEmail newCommentAddedEmail(Poll poll, Comment comment) {
        CommentAddedEmail email = new CommentAddedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setComment(comment);
        return email;
    }

    public CommentEditedEmail newCommentEditedEmail(Poll poll, Comment comment) {
        CommentEditedEmail email = new CommentEditedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setComment(comment);
        return email;
    }

    public CommentDeletedEmail newCommentDeletedEmail(Poll poll, Comment comment) {
        CommentDeletedEmail email = new CommentDeletedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setComment(comment);
        return email;
    }

    public CommentAddedEmail newCommentAddedEmail(Question question, Comment comment) {
        CommentAddedEmail email = new CommentAddedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(question.getPoll());
        email.setComment(comment);
        return email;
    }

    public CommentEditedEmail newCommentEditedEmail(Question question, Comment comment) {
        CommentEditedEmail email = new CommentEditedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(question.getPoll());
        email.setComment(comment);
        return email;
    }

    public CommentDeletedEmail newCommentDeletedEmail(Question question, Comment comment) {
        CommentDeletedEmail email = new CommentDeletedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(question.getPoll());
        email.setComment(comment);
        return email;
    }

    public VoteAddedEmail newVoteAddedEmail(Question question, Vote vote) {
        return new VoteAddedEmail(this.getLocale(), this.getTimeZone(), question.getPoll(), vote);
    }

    public VoteEditedEmail newVoteEditedEmail(Question question, Vote vote) {
        return new VoteEditedEmail(this.getLocale(), this.getTimeZone(), question.getPoll(), vote);
    }

    public VoteDeletedEmail newVoteDeletedEmail(Question question, Vote vote) {
        return new VoteDeletedEmail(this.getLocale(), this.getTimeZone(), question.getPoll(), vote);
    }

    public PollCreatedEmail newPollCreatedEmail(Poll poll) {
        PollCreatedEmail email = new PollCreatedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setPollenUrl(this.pollenUrlHelper().getUiEndPoint());
        PollenEntityId<Poll> pollId = this.getPollenEntityId(poll);
        email.setUrl(this.getPollenUIUrlRenderService().getPollEditUrl(this.pollenUrlHelper().getPollEditUrl(), pollId.getReducedId(), poll.getCreator().getPermission().getToken()));
        return email;
    }

    public PollClosedEmail newPollClosedEmail(Poll poll) {
        PollClosedEmail email = new PollClosedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        return email;
    }

    public PollChoicePeriodStartedEmail newPollChoicePeriodStartedEmail(Poll poll) {
        PollChoicePeriodStartedEmail email = new PollChoicePeriodStartedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        return email;
    }

    public PollChoicePeriodEndedEmail newPollChoicePeriodEndedEmail(Poll poll) {
        PollChoicePeriodEndedEmail email = new PollChoicePeriodEndedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        return email;
    }

    public PollVotePeriodStartedEmail newPollVotePeriodStartedEmail(Poll poll) {
        PollVotePeriodStartedEmail email = new PollVotePeriodStartedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        return email;
    }

    public PollVotePeriodEndedEmail newPollVotePeriodEndedEmail(Poll poll) {
        PollVotePeriodEndedEmail email = new PollVotePeriodEndedEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        return email;
    }

    public PollVoteReminderEmail newPollVoteReminderEmail(Poll poll) {
        PollVoteReminderEmail email = new PollVoteReminderEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        return email;
    }

    public PollInvitationEmail newPollInvitationEmail(Poll poll) {
        PollInvitationEmail email = new PollInvitationEmail(this.getLocale(), this.getTimeZone());
        List<Question> questions = this.getQuestionService().getQuestions(poll);
        email.setPoll(poll);
        email.setQuestions(questions);
        email.setVoteUrl(this.getPollVoteUrl(poll));
        return email;
    }

    public RestrictedPollInvitationEmail newRestrictedPollInvitationEmail(Poll poll, PollenPrincipal principal) {
        RestrictedPollInvitationEmail email = new RestrictedPollInvitationEmail(this.getLocale(), this.getTimeZone());
        List<Question> questions = this.getQuestionService().getQuestions(poll);
        email.setPoll(poll);
        email.setQuestions(questions);
        email.setPrincipal(principal);
        email.setVoteUrl(this.getPollVoteUrl(poll, principal.getPermission().getToken()));
        email.setToken(principal.getPermission().getToken());
        return email;
    }

    public UserAccountCreatedEmail newUserAccountCreatedEmail(PollenUser user, String token) {
        UserAccountCreatedEmail email = new UserAccountCreatedEmail(this.getLocale(), this.getTimeZone());
        email.setUser(user);
        PollenEntityId<PollenUser> userId = this.getPollenEntityId(user);
        email.setValidateUrl(this.getPollenUIUrlRenderService().getUserValidateUrl(this.pollenUrlHelper().getUserValidateUrl(), userId.getReducedId(), token));
        return email;
    }

    public UserAccountCreatedFromProviderEmail newUserAccountCreatedFromProviderEmail(PollenUser user, UserCredential credential) {
        UserAccountCreatedFromProviderEmail email = new UserAccountCreatedFromProviderEmail(this.getLocale(), this.getTimeZone());
        email.setUser(user);
        email.setProvider(I18n.t((String)("pollen.service.mail.loginProvider." + credential.getProvider()), (Object[])new Object[0]));
        email.setProfileUrl(this.pollenUrlHelper().getProfileUrl());
        return email;
    }

    public UserAccountEditedEmail newUserAccountEditedEmail(PollenUser user) {
        UserAccountEditedEmail email = new UserAccountEditedEmail(this.getLocale(), this.getTimeZone());
        email.setUser(user);
        return email;
    }

    public UserAccountDeletedEmail newUserAccountDeletedEmail(PollenUser user) {
        UserAccountDeletedEmail email = new UserAccountDeletedEmail(this.getLocale(), this.getTimeZone());
        email.setUser(user);
        return email;
    }

    public UserAccountEmailAddressAddedEmail newUserAccountEmailAddressAddedEmail(PollenUser user, String token) {
        UserAccountEmailAddressAddedEmail email = new UserAccountEmailAddressAddedEmail(this.getLocale(), this.getTimeZone());
        email.setUser(user);
        PollenEntityId<PollenUser> userId = this.getPollenEntityId(user);
        email.setValidateUrl(this.getPollenUIUrlRenderService().getUserValidateUrl(this.pollenUrlHelper().getUserValidateUrl(), userId.getReducedId(), token));
        return email;
    }

    public UserAccountEmailValidatedEmail newUserAccountEmailValidatedEmail(PollenUser user) {
        UserAccountEmailValidatedEmail email = new UserAccountEmailValidatedEmail(this.getLocale(), this.getTimeZone());
        email.setUser(user);
        email.setPollenUrl(this.pollenUrlHelper().getUiEndPoint());
        return email;
    }

    public ResendValidationEmail newUserResendValidationEmail(PollenUser user, String token) {
        ResendValidationEmail email = new ResendValidationEmail(this.getLocale(), this.getTimeZone());
        email.setUser(user);
        PollenEntityId<PollenUser> userId = this.getPollenEntityId(user);
        email.setValidateUrl(this.getPollenUIUrlRenderService().getUserValidateUrl(this.pollenUrlHelper().getUserValidateUrl(), userId.getReducedId(), token));
        return email;
    }

    public UserAccountPasswordChangedEmail newUserAccountPasswordChangedEmail(PollenUser user) {
        UserAccountPasswordChangedEmail email = new UserAccountPasswordChangedEmail(this.getLocale(), this.getTimeZone());
        email.setUser(user);
        return email;
    }

    public LostPasswordEmail newLostPasswordEmail(PollenUser user, String password, String emailAddress) {
        LostPasswordEmail email = new LostPasswordEmail(this.getLocale(), this.getTimeZone());
        email.setUser(user);
        email.setPassword(password);
        email.setEmailAddress(emailAddress);
        email.setPollenUrl(this.pollenUrlHelper().getUiEndPoint());
        return email;
    }

    public PollEndReminderEmail newPollEndReminderEmail(Poll poll) {
        return this.newPollEndReminderEmail(poll, this.getLocale());
    }

    public PollEndReminderEmail newPollEndReminderEmail(Poll poll, Locale locale) {
        PollEndReminderEmail email = new PollEndReminderEmail(locale, this.getTimeZone());
        email.setPoll(poll);
        return email;
    }

    public void send(PollenMail mail) {
        this.doSend(mail);
    }

    public void resendEmails() {
        EmailToResendDao emailToResendDao = this.getEmailToResendDao();
        List allEmailsToResend = emailToResendDao.findAll();
        if (log.isDebugEnabled()) {
            log.debug("Send " + allEmailsToResend.size() + " emails ...");
        }
        for (EmailToResend emailToResend : allEmailsToResend) {
            block15: {
                try {
                    String to = emailToResend.getTos();
                    HashSet<String> tos = new HashSet<String>();
                    if (StringUtils.isNotBlank((CharSequence)to)) {
                        tos.addAll(Arrays.asList(to.split(RECIPIENT_SEPARATOR)));
                    }
                    String bcc = emailToResend.getBccs();
                    HashSet<String> bccs = new HashSet<String>();
                    if (StringUtils.isNotBlank((CharSequence)bcc)) {
                        bccs.addAll(Arrays.asList(bcc.split(RECIPIENT_SEPARATOR)));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Will send mail: to = '" + to + "', bcc = '" + bcc + "'");
                    }
                    List<InternetAddress> replyTo = null;
                    if (StringUtils.isNotEmpty((CharSequence)emailToResend.getReplyTo())) {
                        try {
                            replyTo = Arrays.asList(InternetAddress.parse((String)emailToResend.getReplyTo()));
                        }
                        catch (AddressException e) {
                            throw new PollenTechnicalException("error parse replyTo", e);
                        }
                    }
                    this.doSend(emailToResend.getSubject(), emailToResend.getBody(), emailToResend.getAdrFrom(), replyTo, tos, bccs);
                    emailToResendDao.delete(emailToResend);
                    this.commit();
                }
                catch (EmailException e) {
                    if (e.getCause() instanceof SendFailedException) {
                        SendFailedException sendFailedException = (SendFailedException)e.getCause();
                        if (ArrayUtils.isNotEmpty((Object[])sendFailedException.getInvalidAddresses())) {
                            List emails = Stream.of(sendFailedException.getInvalidAddresses()).map(Address::toString).collect(Collectors.toList());
                            this.getPollenPrincipalDao().forEmailIn(emails).findAll().forEach(pollenPrincipal -> pollenPrincipal.setInvalid(true));
                            this.commit();
                        }
                    }
                    if (!log.isErrorEnabled()) break block15;
                    log.error("Error while resending an email, keep it and try again", (Throwable)e);
                }
            }
            try {
                TimeUnit.MILLISECONDS.sleep(this.getPollenServiceConfig().getSmtpWait());
            }
            catch (InterruptedException e) {
                if (log.isErrorEnabled()) {
                    log.error("Error while resending an email, Interrupted sleeping", (Throwable)e);
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void doSend(PollenMail mail) {
        if (mail.isRecipientProvided()) {
            InternetAddress fromAddress;
            String subject = mail.getSubject();
            String body = this.getBody(mail);
            Set<String> tos = mail.getTos();
            Set<String> bccs = mail.getBccs();
            String smtpFrom = this.getPollenServiceConfig().getSmtpFrom();
            try {
                fromAddress = new InternetAddress(smtpFrom);
                if (StringUtils.isNotBlank((CharSequence)mail.getFromName())) {
                    String personal = I18n.l((Locale)this.getLocale(), (String)"pollen.service.mail.from.via", (Object[])new Object[]{mail.getFromName(), fromAddress.getPersonal()});
                    fromAddress.setPersonal(personal);
                }
            }
            catch (AddressException | UnsupportedEncodingException e) {
                throw new PollenTechnicalException("Error on smtp from adresse", e);
            }
            String[] emailSplit = fromAddress.getAddress().split("@");
            String userFrom = emailSplit[0];
            String domainFrom = emailSplit[1];
            String mailId = this.getMailId(mail);
            fromAddress.setAddress(userFrom + MAIL_ID_SEPARATOR + mailId + "@" + domainFrom);
            String from = fromAddress.toUnicodeString();
            Collection<InternetAddress> replyTo = mail.getReplyTo();
            EmailToResend emailToResend = (EmailToResend)this.getEmailToResendDao().create();
            emailToResend.setSubject(subject);
            emailToResend.setBody(body);
            emailToResend.setAdrFrom(from);
            emailToResend.setReplyTo(replyTo.stream().map(InternetAddress::toUnicodeString).collect(Collectors.joining(", ")));
            emailToResend.setTos(StringUtils.join(tos, (String)RECIPIENT_SEPARATOR));
            emailToResend.setBccs(StringUtils.join(bccs, (String)RECIPIENT_SEPARATOR));
            if (log.isInfoEnabled()) {
                log.info("record email after send : " + mailId);
            }
        } else if (log.isErrorEnabled()) {
            log.error("email has no recipient, won't be sent " + String.valueOf(mail));
        }
    }

    protected void doSend(String subject, String body, String from, Collection<InternetAddress> replyTo, Collection<String> tos, Collection<String> bccs) throws EmailException {
        PollenServicesConfig applicationConfig;
        if (log.isDebugEnabled()) {
            log.debug("doSend: tos = '" + String.valueOf(tos) + "', bccs = '" + String.valueOf(bccs) + "'");
        }
        if ((applicationConfig = this.getPollenServiceConfig()).getSmtpHost() == null) {
            if (log.isInfoEnabled()) {
                log.info("an email should have been sent if not in devMode: tos = " + String.valueOf(tos) + ". subject = '" + subject + "'. body = \n" + body);
            }
            if (log.isWarnEnabled() && (tos == null || tos.isEmpty()) && (bccs == null || bccs.isEmpty())) {
                log.warn("email has no recipient, would not have been sent");
            }
        } else {
            SimpleEmail newEmail = new SimpleEmail();
            if (log.isDebugEnabled()) {
                newEmail.setDebug(true);
            }
            this.configSmtp((Email)newEmail, applicationConfig);
            newEmail.setCharset(StandardCharsets.UTF_8.name());
            newEmail.setSubject(subject);
            try {
                InternetAddress fromAdr = new InternetAddress(from);
                newEmail.setFrom(fromAdr.getAddress(), fromAdr.getPersonal());
            }
            catch (AddressException e) {
                log.warn("Could not parse address");
            }
            if (CollectionUtils.isNotEmpty(replyTo)) {
                newEmail.setReplyTo(replyTo);
            }
            for (String to : tos) {
                newEmail.addTo(to);
            }
            for (String bcc : bccs) {
                newEmail.addBcc(bcc);
            }
            newEmail.setMsg(body);
            try {
                newEmail.send();
            }
            catch (Throwable e) {
                throw new PollenTechnicalException("[doSend] newEmail.send() failed: " + String.valueOf(e), e);
            }
            if (log.isInfoEnabled()) {
                log.info("send email to : " + String.join((CharSequence)", ", tos) + " - from " + from);
            }
        }
    }

    protected void configSmtp(Email email, PollenServicesConfig applicationConfig) {
        email.setHostName(applicationConfig.getSmtpHost());
        email.setSmtpPort(applicationConfig.getSmtpPort());
        Optional.ofNullable(applicationConfig.getSmtpSslPort()).map(String::valueOf).ifPresent(arg_0 -> ((Email)email).setSslSmtpPort(arg_0));
        email.setSSLOnConnect(applicationConfig.isSmtpUseSSLTLS());
        email.setStartTLSEnabled(applicationConfig.isSmtpUseStartTLS());
        if (log.isDebugEnabled()) {
            String toString = MoreObjects.toStringHelper(email.getClass()).add("hostName", (Object)email.getHostName()).add("smtpPort", (Object)email.getSmtpPort()).add("sslSmtpPort", (Object)email.getSslSmtpPort()).add("sslOnConnect", email.isSSLOnConnect()).add("startTlsEnabled", email.isStartTLSEnabled()).toString();
            log.debug("doSend: created email: " + toString);
        }
        if (applicationConfig.getSmtpUsername() != null || applicationConfig.getSmtpPassword() != null) {
            email.setAuthentication(applicationConfig.getSmtpUsername(), applicationConfig.getSmtpPassword());
            if (log.isDebugEnabled()) {
                log.debug("doSend: Set username/password for user=" + applicationConfig.getSmtpUsername());
            }
        }
    }

    protected String getBody(PollenMail mail) {
        Mustache mustache = this.getMustache(mail);
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, (Object)mail);
        Object body = String.valueOf(stringWriter) + mail.getSigning();
        if (mail.getTos().size() == 1) {
            body = this.getCryptoService().encryptMailIfAsKey((String)body, (String)IterableUtils.get(mail.getTos(), (int)0));
        }
        return body;
    }

    protected Mustache getMustache(PollenMail mail) {
        Mustache mustache;
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory("email/");
        Locale locale = mail.getLocale();
        Object signingTemplateName = "signing_" + locale.getLanguage() + ".mustache";
        String templateName = mail.getClass().getSimpleName() + "_" + locale.getLanguage() + ".mustache";
        try {
            mail.setSigning(this.getSigning((MustacheFactory)mustacheFactory, (String)signingTemplateName));
            mustache = mustacheFactory.compile(templateName);
        }
        catch (MustacheException e) {
            signingTemplateName = "signing.mustache";
            mail.setSigning(this.getSigning((MustacheFactory)mustacheFactory, (String)signingTemplateName));
            templateName = mail.getClass().getSimpleName() + ".mustache";
            mustache = mustacheFactory.compile(templateName);
        }
        return mustache;
    }

    protected String getSigning(MustacheFactory mustacheFactory, String signingTemplateName) {
        StringWriter stringWriter = new StringWriter();
        Mustache mustache = mustacheFactory.compile(signingTemplateName);
        mustache.execute((Writer)stringWriter, (Object)this.pollenUrlHelper());
        return stringWriter.toString();
    }

    public CommentReportEmail newCommentReportEmail(Poll poll, Comment comment, Report report) {
        CommentReportEmail email = new CommentReportEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setTarget(comment);
        comment.getAuthor().getName();
        email.setReport(report);
        PollenEntityId<Poll> pollId = this.getPollenEntityId(poll);
        String pollUrl = this.getPollenUIUrlRenderService().getPollVoteUrl(this.pollenUrlHelper().getPollVoteUrl(), pollId.getReducedId(), poll.getCreator().getPermission().getToken());
        email.setUrl(pollUrl);
        return email;
    }

    public CommentReportForAdminEmail newCommentReportForAdminEmail(Poll poll, Comment comment, Report report, PollenUser admin) {
        CommentReportForAdminEmail email = new CommentReportForAdminEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setTarget(comment);
        comment.getAuthor().getName();
        email.setReport(report);
        PollenEntityId<Poll> pollId = this.getPollenEntityId(poll);
        String pollUrl = this.getPollenUIUrlRenderService().getPollVoteUrl(this.pollenUrlHelper().getPollVoteUrl(), pollId.getReducedId(), null);
        email.setUrl(pollUrl);
        email.setAdministrator(admin);
        email.setReports(this.getReportDao().forTargetIdEquals(comment.getTopiaId()).findAll());
        email.setResume(this.getReportDao().getReportResume(comment.getTopiaId()));
        return email;
    }

    public ChoiceReportEmail newChoiceReportEmail(Poll poll, Choice choice, Report report) {
        ChoiceReportEmail email = new ChoiceReportEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setTarget(choice);
        email.setReport(report);
        email.setChoiceValue(this.getChoiceValue(choice));
        PollenEntityId<Poll> pollId = this.getPollenEntityId(poll);
        String pollUrl = this.getPollenUIUrlRenderService().getPollVoteUrl(this.pollenUrlHelper().getPollVoteUrl(), pollId.getReducedId(), poll.getCreator().getPermission().getToken());
        email.setUrl(pollUrl);
        return email;
    }

    public ChoiceReportForAdminEmail newChoiceReportForAdminEmail(Poll poll, Choice choice, Report report, PollenUser admin) {
        ChoiceReportForAdminEmail email = new ChoiceReportForAdminEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setTarget(choice);
        email.setReport(report);
        email.setChoiceValue(this.getChoiceValue(choice));
        PollenEntityId<Poll> pollId = this.getPollenEntityId(poll);
        String pollUrl = this.getPollenUIUrlRenderService().getPollVoteUrl(this.pollenUrlHelper().getPollVoteUrl(), pollId.getReducedId(), null);
        email.setUrl(pollUrl);
        email.setAdministrator(admin);
        email.setReports(this.getReportDao().forTargetIdEquals(choice.getTopiaId()).findAll());
        email.setResume(this.getReportDao().getReportResume(choice.getTopiaId()));
        return email;
    }

    public PollReportEmail newPollReportEmail(Poll poll, Report report) {
        PollReportEmail email = new PollReportEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setTarget(poll);
        email.setReport(report);
        PollenEntityId<Poll> pollId = this.getPollenEntityId(poll);
        String pollUrl = this.getPollenUIUrlRenderService().getPollVoteUrl(this.pollenUrlHelper().getPollVoteUrl(), pollId.getReducedId(), poll.getCreator().getPermission().getToken());
        email.setUrl(pollUrl);
        return email;
    }

    public PollReportForAdminEmail newPollReportForAdminEmail(Poll poll, Report report, PollenUser admin) {
        PollReportForAdminEmail email = new PollReportForAdminEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setTarget(poll);
        email.setReport(report);
        PollenEntityId<Poll> pollId = this.getPollenEntityId(poll);
        String pollUrl = this.getPollenUIUrlRenderService().getPollVoteUrl(this.pollenUrlHelper().getPollVoteUrl(), pollId.getReducedId(), null);
        email.setUrl(pollUrl);
        email.setAdministrator(admin);
        email.setReports(this.getReportDao().forTargetIdEquals(poll.getTopiaId()).findAll());
        email.setResume(this.getReportDao().getReportResume(poll.getTopiaId()));
        return email;
    }

    protected String getChoiceValue(Choice choice) {
        return switch (choice.getChoiceType()) {
            case ChoiceType.DATE, ChoiceType.DATETIME -> {
                Date date = new Date(Long.parseLong(choice.getChoiceValue()));
                yield PollenMail.formatDate(date, this.getLocale(), this.getTimeZone());
            }
            case ChoiceType.RESOURCE -> {
                PollenResource resource = (PollenResource)this.getPollenResourceDao().forTopiaIdEquals(choice.getChoiceValue()).findUnique();
                PollenEntityId<PollenResource> resourceId = this.getPollenEntityId(resource);
                yield this.getPollenUIUrlRenderService().getResourceUrl(this.pollenUrlHelper().getResourceUrl(), resourceId.getReducedId());
            }
            default -> choice.getChoiceValue();
        };
    }

    public FeedbackEmail newFeedbackMail(FeedbackBean feedbackBean, PollenUserBean user, Locale locale) {
        FeedbackEmail email = new FeedbackEmail(locale, this.getTimeZone());
        email.setUser(user);
        email.setFeedback(feedbackBean);
        email.setFeedbackDate(this.getNow());
        email.setUserEmail(feedbackBean.getUserEmail());
        if (feedbackBean.getScreenShotId() != null) {
            String screenShotUrl = this.getPollenUIUrlRenderService().getResourceUrl(this.pollenUrlHelper().getResourceUrl(), feedbackBean.getScreenShotId().getReducedId());
            email.setScreenShotUrl(screenShotUrl);
        }
        String version = this.getClass().getPackage().getImplementationVersion();
        email.setApplicationVersion(version);
        return email;
    }

    public ExceedingMaxVotersEmail newExceedingMaxVotersEmail(Poll poll, int maxVoters) {
        ExceedingMaxVotersEmail email = new ExceedingMaxVotersEmail(this.getLocale(), this.getTimeZone());
        email.setPoll(poll);
        email.setMaxVoters(maxVoters);
        email.setOffersUrl(this.pollenUrlHelper().getOffersUrl());
        return email;
    }

    protected String getMailId(PollenMail mail) {
        PollenMailType pollenEmailType = PollenMailType.valueOfMail(mail);
        return pollenEmailType.name() + MAIL_ID_SEPARATOR + mail.getEntitiesKey().stream().map(entity -> PollenEmailKeyType.valueOfEntity(entity).name() + PollenEntityId.getReduceId(entity)).collect(Collectors.joining(MAIL_ID_SEPARATOR));
    }

    void forward(Message messageToForward, Set<String> tos, String subject, String body, String from) throws EmailException, MessagingException {
        Preconditions.checkArgument((!tos.isEmpty() ? 1 : 0) != 0, (Object)("il faut pr\u00e9ciser au moins un destinataire \u00e0 qui faire suivre le message " + String.valueOf(messageToForward)));
        PollenServicesConfig applicationConfig = this.getPollenServiceConfig();
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setText(body);
        MimeBodyPart messageToForwardAsAttachment = new MimeBodyPart();
        messageToForwardAsAttachment.setContent((Object)messageToForward, "message/rfc822");
        messageToForwardAsAttachment.setDisposition("attachment");
        MultiPartEmail newEmail = new MultiPartEmail();
        this.configSmtp((Email)newEmail, applicationConfig);
        newEmail.setCharset(StandardCharsets.UTF_8.name());
        newEmail.setSubject(subject);
        newEmail.setFrom(from);
        for (String to : tos) {
            newEmail.addTo(to);
        }
        newEmail.setMsg(body);
        newEmail.addHeader("Return-Path", "<>");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)bodyPart);
        multipart.addBodyPart((BodyPart)messageToForwardAsAttachment);
        newEmail.setContent(multipart);
        try {
            newEmail.send();
        }
        catch (Throwable e) {
            throw new PollenTechnicalException("[forward] newEmail.send() failed: " + String.valueOf(e), e);
        }
    }

    static {
        I18n.n((String)"pollen.service.mail.loginProvider.amazon", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.facebook", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.flickr", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.foursquare", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.github", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.googleplus", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.hotmail", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.instagram", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.linkedin", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.linkedin2", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.mendeley", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.myspace", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.nimble", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.runkeeper", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.salesforce", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.stackexchange", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.twitter", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.yahoo", (Object[])new Object[0]);
        I18n.n((String)"pollen.service.mail.loginProvider.yammer", (Object[])new Object[0]);
    }
}

