package org.chorem.pollen.entities.migration;
/*
 * #%L
 * Pollen :: Services
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.chorem.pollen.business.persistence.Poll;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClassNG;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

import java.util.List;

/**
 * Migration for version {@code 1.4.5}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class PollenMigrationCallbackV1_4_5 extends TopiaMigrationCallbackByClassNG.MigrationCallBackForVersion {

    @Override
    public Version getVersion() {
        return VersionUtil.valueOf("1.4.5");
    }

    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx,
                                          List<String> queries,
                                          boolean showSql,
                                          boolean showProgression) throws TopiaException {

        // add pollVoteVisibility on poll (instead of anonymous flag on poll)
        // see http://chorem.org/issues/742
        addPollVoteVisibility(queries);

        // add pollCommentVisibilite on Poll
        // see http://chorem.org/issues/743
        addPollCommentVisibility(queries);
    }

    private void addPollVoteVisibility(List<String> queries) throws TopiaException {

        // add pollVoteVisibility integer  on poll
        queries.add("ALTER TABLE poll ADD COLUMN " +
                    Poll.PROPERTY_POLL_VOTE_VISIBILITY + " INT NOT NULL DEFAULT 0;");

        // Poll anonymous = PollVoteAnonymous.NOBODY = 0
        queries.add("UPDATE poll SET " +
                    Poll.PROPERTY_POLL_VOTE_VISIBILITY + " = 0 WHERE anonymous = true;");

        // Poll anonymous = PollVoteAnonymous.EVERYBODY = 3
        queries.add("UPDATE poll SET " +
                    Poll.PROPERTY_POLL_VOTE_VISIBILITY + " = 3 WHERE anonymous = false;");

        // remove Poll anonymous
        queries.add("ALTER TABLE poll DROP COLUMN anonymous;");
    }

    private void addPollCommentVisibility(List<String> queries) throws TopiaException {

        // add pollCommentVisibility integer  on poll
        queries.add("ALTER TABLE poll ADD COLUMN " +
                    Poll.PROPERTY_POLL_COMMENT_VISIBILITY + " INT NOT NULL DEFAULT 0;");

        // All polls were previously authorize = PollCommentVisibility.EVERYBODY = 1
        queries.add("UPDATE poll SET " +
                    Poll.PROPERTY_POLL_COMMENT_VISIBILITY + " = 1;");


    }

}
