/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.chorem.pollen.business.converters.DataChoiceConverter;
import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.VoteDTO;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VoteToChoiceDAO;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.persistence.VotingListDAO;
import org.nuiton.topia.TopiaException;

public class DataVoteConverter
extends DataConverter {
    public void populateVoteEntity(VoteDTO voteDTO, Vote eVote) throws TopiaException {
        eVote.setWeight(voteDTO.getWeight());
        eVote.setComment(voteDTO.getComment());
        eVote.setAnonymous(voteDTO.isAnonymous());
        if (voteDTO.getPollId() != null) {
            PollDAO pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Poll pollEntity = (Poll)pollDAO.findByTopiaId(voteDTO.getPollId());
            pollEntity.addVote(eVote);
            eVote.setPoll(pollEntity);
        }
        if (voteDTO.getPollAccountId() != null) {
            PollAccountDAO pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            PollAccount pollAccountEntity = (PollAccount)pollAccountDAO.findByTopiaId(voteDTO.getPollAccountId());
            eVote.setPollAccount(pollAccountEntity);
        }
        if (voteDTO.getVotingListId() != null) {
            VotingListDAO votingListDAO = PollenModelDAOHelper.getVotingListDAO(this.transaction);
            VotingList votingListEntity = (VotingList)votingListDAO.findByTopiaId(voteDTO.getVotingListId());
            eVote.setVotingList(votingListEntity);
        }
    }

    public VoteDTO createVoteDTO(Vote eVote) {
        VoteDTO voteDTO = new VoteDTO();
        voteDTO.setId(eVote.getTopiaId());
        voteDTO.setWeight(eVote.getWeight());
        voteDTO.setComment(eVote.getComment());
        voteDTO.setAnonymous(eVote.getAnonymous());
        if (eVote.getPoll() != null) {
            voteDTO.setPollId(eVote.getPoll().getTopiaId());
        }
        if (eVote.getPollAccount() != null) {
            voteDTO.setPollAccountId(eVote.getPollAccount().getTopiaId());
        }
        if (eVote.getVotingList() != null) {
            voteDTO.setVotingListId(eVote.getVotingList().getTopiaId());
        }
        if (eVote.getChoiceVoteToChoice() != null) {
            DataChoiceConverter choiceConverter = new DataChoiceConverter();
            for (VoteToChoice voteToChoice : eVote.getChoiceVoteToChoice()) {
                if (voteToChoice.getChoice() == null) continue;
                ChoiceDTO choiceDTO = choiceConverter.createChoiceDTO(voteToChoice.getChoice());
                choiceDTO.setValue(voteToChoice.getVoteValue());
                voteDTO.getChoiceDTOs().add(choiceDTO);
            }
        }
        return voteDTO;
    }

    public List<VoteDTO> createVoteDTOs(Collection<Vote> cVotes) {
        ArrayList<VoteDTO> results = new ArrayList<VoteDTO>();
        for (Vote v : cVotes) {
            VoteDTO dto = this.createVoteDTO(v);
            results.add(dto);
        }
        return results;
    }

    public void populateChoiceVote(VoteDTO voteDTO, Vote eVote) throws TopiaException {
        for (ChoiceDTO choiceDTO : voteDTO.getChoiceDTOs()) {
            choiceDTO.setVoteId(eVote.getTopiaId());
        }
        eVote.setChoiceVoteToChoice(this.getVoteToChoices(voteDTO.getChoiceDTOs()));
    }

    private List<VoteToChoice> getVoteToChoices(List<ChoiceDTO> choiceDTOs) throws TopiaException {
        ArrayList<VoteToChoice> liste = new ArrayList<VoteToChoice>();
        for (ChoiceDTO choice : choiceDTOs) {
            VoteToChoiceDAO voteToChoiceDAO = PollenModelDAOHelper.getVoteToChoiceDAO(this.transaction);
            VoteToChoice voteToChoice = (VoteToChoice)voteToChoiceDAO.create(new Object[0]);
            voteToChoice.setVoteValue(choice.getValue());
            VoteDAO voteDAO = PollenModelDAOHelper.getVoteDAO(this.transaction);
            Vote voteEntity = (Vote)voteDAO.findByTopiaId(choice.getVoteId());
            voteToChoice.setVote(voteEntity);
            ChoiceDAO choiceDAO = PollenModelDAOHelper.getChoiceDAO(this.transaction);
            Choice choiceEntity = (Choice)choiceDAO.findByTopiaId(choice.getId());
            voteToChoice.setChoice(choiceEntity);
            liste.add(voteToChoice);
        }
        return liste;
    }
}

