/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataUserConverter;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.services.ServiceAuth;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceAuthImpl
implements ServiceAuth {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private UserAccountDAO userDAO = null;
    private DataUserConverter converter = new DataUserConverter();
    private static final Log log = LogFactory.getLog(ServiceAuthImpl.class);

    @Override
    public boolean isLoginRight(String login, String password) {
        TopiaContext transaction = null;
        boolean result = false;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            Object userEntity = this.userDAO.findByLogin(login);
            if (userEntity != null && password.equals(userEntity.getPassword())) {
                result = true;
            }
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (userEntity == null ? "null" : userEntity.getLogin())));
            }
            return result;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public UserDTO getUser(String login, String password) {
        TopiaContext transaction = null;
        UserDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            Object userEntity = this.userDAO.findByLogin(login);
            if (userEntity != null && password.equals(userEntity.getPassword())) {
                result = this.converter.createUserDTO((UserAccount)userEntity);
            }
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getLogin())));
            }
            return result;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }
}

