/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"pollId","title","description"},
  numFields={"maxChoiceNb"},
  boolFields={"closed","choiceAddAllowed","anonymousVoteAllowed","anonymous","publicResults","continuousResults"},
  dateFields={"beginChoiceDate","beginDate","endDate"}
)        
public interface Poll extends TopiaEntity {

    public static final String POLL_ID = "pollId";

    public static final String TITLE = "title";

    public static final String DESCRIPTION = "description";

    public static final String BEGIN_CHOICE_DATE = "beginChoiceDate";

    public static final String BEGIN_DATE = "beginDate";

    public static final String END_DATE = "endDate";

    public static final String MAX_CHOICE_NB = "maxChoiceNb";

    public static final String CLOSED = "closed";

    public static final String CHOICE_ADD_ALLOWED = "choiceAddAllowed";

    public static final String ANONYMOUS_VOTE_ALLOWED = "anonymousVoteAllowed";

    public static final String ANONYMOUS = "anonymous";

    public static final String PUBLIC_RESULTS = "publicResults";

    public static final String CONTINUOUS_RESULTS = "continuousResults";

    public static final String VOTE = "vote";

    public static final String CHOICE = "choice";

    public static final String RESULT = "result";

    public static final String CREATOR = "creator";

    public static final String COMMENT = "comment";

    public static final String PREVENT_RULE = "preventRule";

    public static final String VOTING_LIST = "votingList";

    public static final String POLL_TYPE = "pollType";

    public static final String CHOICE_TYPE = "choiceType";

    public static final String VOTE_COUNTING = "voteCounting";

    /**
     * @param pollId La valeur de l'attribut pollId à positionner.
     */
    public void setPollId(java.lang.String pollId);

    /**
     * @return La valeur de l'attribut pollId.
     */
    public java.lang.String getPollId();

    /**
     * @param title La valeur de l'attribut title à positionner.
     */
    public void setTitle(java.lang.String title);

    /**
     * @return La valeur de l'attribut title.
     */
    public java.lang.String getTitle();

    /**
     * @param description La valeur de l'attribut description à positionner.
     */
    public void setDescription(java.lang.String description);

    /**
     * @return La valeur de l'attribut description.
     */
    public java.lang.String getDescription();

    /**
     * @param beginChoiceDate La valeur de l'attribut beginChoiceDate à positionner.
     */
    public void setBeginChoiceDate(java.util.Date beginChoiceDate);

    /**
     * @return La valeur de l'attribut beginChoiceDate.
     */
    public java.util.Date getBeginChoiceDate();

    /**
     * @param beginDate La valeur de l'attribut beginDate à positionner.
     */
    public void setBeginDate(java.util.Date beginDate);

    /**
     * @return La valeur de l'attribut beginDate.
     */
    public java.util.Date getBeginDate();

    /**
     * @param endDate La valeur de l'attribut endDate à positionner.
     */
    public void setEndDate(java.util.Date endDate);

    /**
     * @return La valeur de l'attribut endDate.
     */
    public java.util.Date getEndDate();

    /**
     * @param maxChoiceNb La valeur de l'attribut maxChoiceNb à positionner.
     */
    public void setMaxChoiceNb(java.lang.Integer maxChoiceNb);

    /**
     * @return La valeur de l'attribut maxChoiceNb.
     */
    public java.lang.Integer getMaxChoiceNb();

    /**
     * @param closed La valeur de l'attribut closed à positionner.
     */
    public void setClosed(java.lang.Boolean closed);

    /**
     * @return La valeur de l'attribut closed.
     */
    public java.lang.Boolean getClosed();

    /**
     * @param choiceAddAllowed La valeur de l'attribut choiceAddAllowed à positionner.
     */
    public void setChoiceAddAllowed(java.lang.Boolean choiceAddAllowed);

    /**
     * @return La valeur de l'attribut choiceAddAllowed.
     */
    public java.lang.Boolean getChoiceAddAllowed();

    /**
     * @param anonymousVoteAllowed La valeur de l'attribut anonymousVoteAllowed à positionner.
     */
    public void setAnonymousVoteAllowed(java.lang.Boolean anonymousVoteAllowed);

    /**
     * @return La valeur de l'attribut anonymousVoteAllowed.
     */
    public java.lang.Boolean getAnonymousVoteAllowed();

    /**
     * @param anonymous La valeur de l'attribut anonymous à positionner.
     */
    public void setAnonymous(java.lang.Boolean anonymous);

    /**
     * @return La valeur de l'attribut anonymous.
     */
    public java.lang.Boolean getAnonymous();

    /**
     * @param publicResults La valeur de l'attribut publicResults à positionner.
     */
    public void setPublicResults(java.lang.Boolean publicResults);

    /**
     * @return La valeur de l'attribut publicResults.
     */
    public java.lang.Boolean getPublicResults();

    /**
     * @param continuousResults La valeur de l'attribut continuousResults à positionner.
     */
    public void setContinuousResults(java.lang.Boolean continuousResults);

    /**
     * @return La valeur de l'attribut continuousResults.
     */
    public java.lang.Boolean getContinuousResults();

    /**
     * @param vote L'instance de vote à ajouter.
     */
    public void addVote(org.chorem.pollen.business.persistence.Vote vote);

    /**
     * @param vote Les instances de vote à ajouter.
     */
    public void addAllVote(java.util.List<org.chorem.pollen.business.persistence.Vote> vote);

    /**
     * @param vote La Collection de vote à positionner.
     */
    public void setVote(java.util.List<org.chorem.pollen.business.persistence.Vote> vote);

    /**
     * @param vote L'instance de vote à retirer.
     */
    public void removeVote(org.chorem.pollen.business.persistence.Vote vote);

    /**
     * Vide la Collection de vote.
     */
    public void clearVote();

    /**
     * @return La Liste de vote.
     */
    public java.util.List<org.chorem.pollen.business.persistence.Vote> getVote();


    /**
     * Recupère l'attribut vote à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.Vote getVoteByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection vote.
     */
    public int sizeVote();

    /**
     * @return <code>true</code> si la collection vote est vide.
     */
    public boolean isVoteEmpty();

    /**
     * @param choice L'instance de choice à ajouter.
     */
    public void addChoice(org.chorem.pollen.business.persistence.Choice choice);

    /**
     * @param choice Les instances de choice à ajouter.
     */
    public void addAllChoice(java.util.List<org.chorem.pollen.business.persistence.Choice> choice);

    /**
     * @param choice La Collection de choice à positionner.
     */
    public void setChoice(java.util.List<org.chorem.pollen.business.persistence.Choice> choice);

    /**
     * @param choice L'instance de choice à retirer.
     */
    public void removeChoice(org.chorem.pollen.business.persistence.Choice choice);

    /**
     * Vide la Collection de choice.
     */
    public void clearChoice();

    /**
     * @return La Liste de choice.
     */
    public java.util.List<org.chorem.pollen.business.persistence.Choice> getChoice();


    /**
     * Recupère l'attribut choice à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.Choice getChoiceByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection choice.
     */
    public int sizeChoice();

    /**
     * @return <code>true</code> si la collection choice est vide.
     */
    public boolean isChoiceEmpty();

    /**
     * @param result L'instance de result à ajouter.
     */
    public void addResult(org.chorem.pollen.business.persistence.Result result);

    /**
     * @param result Les instances de result à ajouter.
     */
    public void addAllResult(java.util.List<org.chorem.pollen.business.persistence.Result> result);

    /**
     * @param result La Collection de result à positionner.
     */
    public void setResult(java.util.List<org.chorem.pollen.business.persistence.Result> result);

    /**
     * @param result L'instance de result à retirer.
     */
    public void removeResult(org.chorem.pollen.business.persistence.Result result);

    /**
     * Vide la Collection de result.
     */
    public void clearResult();

    /**
     * @return La Liste de result.
     */
    public java.util.List<org.chorem.pollen.business.persistence.Result> getResult();


    /**
     * Recupère l'attribut result à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.Result getResultByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection result.
     */
    public int sizeResult();

    /**
     * @return <code>true</code> si la collection result est vide.
     */
    public boolean isResultEmpty();

    /**
     * @param creator La valeur de l'attribut creator à positionner.
     */
    public void setCreator(org.chorem.pollen.business.persistence.PollAccount creator);

    /**
     * @return La valeur de l'attribut creator.
     */
    public org.chorem.pollen.business.persistence.PollAccount getCreator();

    /**
     * @param comment L'instance de comment à ajouter.
     */
    public void addComment(org.chorem.pollen.business.persistence.Comment comment);

    /**
     * @param comment Les instances de comment à ajouter.
     */
    public void addAllComment(java.util.List<org.chorem.pollen.business.persistence.Comment> comment);

    /**
     * @param comment La Collection de comment à positionner.
     */
    public void setComment(java.util.List<org.chorem.pollen.business.persistence.Comment> comment);

    /**
     * @param comment L'instance de comment à retirer.
     */
    public void removeComment(org.chorem.pollen.business.persistence.Comment comment);

    /**
     * Vide la Collection de comment.
     */
    public void clearComment();

    /**
     * @return La Liste de comment.
     */
    public java.util.List<org.chorem.pollen.business.persistence.Comment> getComment();


    /**
     * Recupère l'attribut comment à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.Comment getCommentByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection comment.
     */
    public int sizeComment();

    /**
     * @return <code>true</code> si la collection comment est vide.
     */
    public boolean isCommentEmpty();

    /**
     * @param preventRule L'instance de preventRule à ajouter.
     */
    public void addPreventRule(org.chorem.pollen.business.persistence.PreventRule preventRule);

    /**
     * @param preventRule Les instances de preventRule à ajouter.
     */
    public void addAllPreventRule(java.util.List<org.chorem.pollen.business.persistence.PreventRule> preventRule);

    /**
     * @param preventRule La Collection de preventRule à positionner.
     */
    public void setPreventRule(java.util.List<org.chorem.pollen.business.persistence.PreventRule> preventRule);

    /**
     * @param preventRule L'instance de preventRule à retirer.
     */
    public void removePreventRule(org.chorem.pollen.business.persistence.PreventRule preventRule);

    /**
     * Vide la Collection de preventRule.
     */
    public void clearPreventRule();

    /**
     * @return La Liste de preventRule.
     */
    public java.util.List<org.chorem.pollen.business.persistence.PreventRule> getPreventRule();


    /**
     * Recupère l'attribut preventRule à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.PreventRule getPreventRuleByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection preventRule.
     */
    public int sizePreventRule();

    /**
     * @return <code>true</code> si la collection preventRule est vide.
     */
    public boolean isPreventRuleEmpty();

    /**
     * @param votingList L'instance de votingList à ajouter.
     */
    public void addVotingList(org.chorem.pollen.business.persistence.VotingList votingList);

    /**
     * @param votingList Les instances de votingList à ajouter.
     */
    public void addAllVotingList(java.util.List<org.chorem.pollen.business.persistence.VotingList> votingList);

    /**
     * @param votingList La Collection de votingList à positionner.
     */
    public void setVotingList(java.util.List<org.chorem.pollen.business.persistence.VotingList> votingList);

    /**
     * @param votingList L'instance de votingList à retirer.
     */
    public void removeVotingList(org.chorem.pollen.business.persistence.VotingList votingList);

    /**
     * Vide la Collection de votingList.
     */
    public void clearVotingList();

    /**
     * @return La Liste de votingList.
     */
    public java.util.List<org.chorem.pollen.business.persistence.VotingList> getVotingList();


    /**
     * Recupère l'attribut votingList à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.VotingList getVotingListByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection votingList.
     */
    public int sizeVotingList();

    /**
     * @return <code>true</code> si la collection votingList est vide.
     */
    public boolean isVotingListEmpty();

    /**
     * @param pollType La valeur de l'attribut pollType à positionner.
     */
    public void setPollType(org.chorem.pollen.business.persistence.PollType pollType);

    /**
     * @return La valeur de l'attribut pollType.
     */
    public org.chorem.pollen.business.persistence.PollType getPollType();

    /**
     * @param choiceType La valeur de l'attribut choiceType à positionner.
     */
    public void setChoiceType(org.chorem.pollen.business.persistence.ChoiceType choiceType);

    /**
     * @return La valeur de l'attribut choiceType.
     */
    public org.chorem.pollen.business.persistence.ChoiceType getChoiceType();

    /**
     * @param voteCounting La valeur de l'attribut voteCounting à positionner.
     */
    public void setVoteCounting(org.chorem.pollen.business.persistence.VoteCounting voteCounting);

    /**
     * @return La valeur de l'attribut voteCounting.
     */
    public org.chorem.pollen.business.persistence.VoteCounting getVoteCounting();

} //Poll
