/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.ServicePollAccountImpl;
import org.chorem.pollen.business.ServiceVote;
import org.chorem.pollen.business.converters.DataVoteConverter;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.VoteDTO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceVoteImpl
implements ServiceVote {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private VoteDAO voteDAO = null;
    private DataVoteConverter converter = new DataVoteConverter();
    private static final Log log = LogFactory.getLog(ServiceVoteImpl.class);

    @Override
    public String createVote(VoteDTO voteDTO, PollAccountDTO pollAccountDTO) {
        String topiaId = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            if (pollAccountDTO != null) {
                PollAccountDTO account = spa.findPollAccountById(pollAccountDTO.getId());
                if (account != null) {
                    log.debug((Object)("Compte associ\u00e9 au vote : " + account.getId()));
                    spa.updatePollAccount(pollAccountDTO);
                    voteDTO.setPollAccountId(account.getId());
                } else {
                    log.debug((Object)"Nouveau compte associ\u00e9 au vote");
                    voteDTO.setPollAccountId(spa.createPollAccount(pollAccountDTO));
                }
                voteDTO.setVotingListId(pollAccountDTO.getVotingListId());
                voteDTO.setWeight(pollAccountDTO.getWeight());
                log.debug((Object)("Poids du vote : " + voteDTO.getWeight()));
            } else {
                voteDTO.setPollAccountId(null);
            }
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(this.transaction);
            Vote voteEntity = (Vote)this.voteDAO.create(new Object[0]);
            this.converter.setTransaction(this.transaction);
            this.converter.populateVoteEntity(voteDTO, voteEntity);
            this.transaction.commitTransaction();
            this.converter.populateChoiceVote(voteDTO, voteEntity);
            topiaId = voteEntity.getTopiaId();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public boolean updateVote(VoteDTO voteDTO) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(this.transaction);
            Vote voteEntity = (Vote)this.voteDAO.findByTopiaId(voteDTO.getId());
            this.converter.setTransaction(this.transaction);
            this.converter.populateVoteEntity(voteDTO, voteEntity);
            voteEntity.update();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + voteDTO.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean deleteVote(VoteDTO voteDTO) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(this.transaction);
            Vote voteEntity = (Vote)this.voteDAO.findByTopiaId(voteDTO.getId());
            voteEntity.delete();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity deleted: " + voteDTO.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public List<VoteDTO> selectVotes(Map<String, Object> properties) {
        List<VoteDTO> results = null;
        List voteEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(this.transaction);
            if (properties == null) {
                voteEntities = this.voteDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les votes ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                voteEntities = this.voteDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(this.transaction);
            results = this.converter.createVoteDTOs(voteEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

